//
//  HWMToolBarItemConfigController.m
//  HWMUISDKNativeDemo
//
//  Created by tyfinal on 2021/6/28.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMToolBarItemConfigController.h"
#import "NSButton+HWMExtension.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMToolBarConfigDataSource.h"
#import "HWMItemConfigModel.h"
#import <HWMUISDK/HWMSdk.h>

@interface HWMToolBarItemConfigController ()<NSTextViewDelegate>
{
}
@property (nonatomic, strong) NSArray *buttonTitlesArray;
@property (nonatomic, strong) NSTextView *textView;

@end

@implementation HWMToolBarItemConfigController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do view setup here.
    [self setUpUI];
    NSLog(@"%@", self.defaultConfig);
    self.textView.string = [self convertDictionaryToJsonString:[self defaultConfig]];
}

- (NSTextView *)textView {
    if (!_textView) {
        NSTextView *textView = [[NSTextView alloc] initWithFrame:NSMakeRect(0, 0, 555, 111)];

        self.textView = textView;
        textView.insertionPointColor = [NSColor colorWithR:102 g:102 b:102];
        textView.backgroundColor = [NSColor whiteColor];
        textView.richText = NO;
        textView.delegate = self;
        textView.autoresizingMask = NSViewHeightSizable;
        textView.font = [NSFont systemFontOfSize:13];
        textView.textColor = [NSColor colorWithR:51 g:51 b:51];
        textView.textContainerInset = NSMakeSize(5, 5);
        NSMutableParagraphStyle *style = [[NSMutableParagraphStyle alloc] init];
        style.lineSpacing = 5;
        textView.defaultParagraphStyle = style;
    }
    return _textView;
}

- (void)setUpUI {
    NSView *borderView = [[NSView alloc]init];
    borderView.wantsLayer = YES;
    borderView.layer.borderWidth = 1.0;
    borderView.layer.borderColor = [NSColor lightGrayColor].CGColor;
    [self.view addSubview:borderView];

    NSScrollView *scrollView = [[NSScrollView alloc]initWithFrame:CGRectZero];
    scrollView.backgroundColor = [NSColor colorWithR:248 g:248 b:248];
    scrollView.autohidesScrollers = NO;
    scrollView.hasVerticalScroller = YES;
    scrollView.hasHorizontalScroller = NO;
    scrollView.verticalScrollElasticity = NSScrollElasticityAutomatic;
    scrollView.horizontalScrollElasticity = NSScrollElasticityNone;
    scrollView.wantsLayer = YES;
    [self.view addSubview:scrollView];
    [scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(20);
        make.leading.mas_equalTo(20);
        make.trailing.mas_equalTo(-20);
        make.height.mas_equalTo(260);
    }];
    scrollView.contentView.documentView = self.textView;

    [borderView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(scrollView).with.insets(NSEdgeInsetsMake(-2, -2, -2, -2));
    }];

    NSView *containerView = [[NSView alloc]init];
    [self.view addSubview:containerView];

    NSButton *button = [NSButton buttonWithTitle:@"使用外部输入" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(clickEvent:)];
    button.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    button.layer.cornerRadius = 4.0;
    button.layer.masksToBounds = YES;
    button.tag = 101;
    [self.view addSubview:button];
    [button mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view.mas_centerX);
        make.top.equalTo(scrollView.mas_bottom).with.offset(20);
        make.size.mas_equalTo(NSMakeSize(120, 45));
    }];

    NSButton *resetButton = [NSButton buttonWithTitle:@"使用初始默认" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(clickEvent:)];
    resetButton.tag = 100;
    resetButton.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    resetButton.layer.cornerRadius = 4.0;
    resetButton.layer.masksToBounds = YES;
    [self.view addSubview:resetButton];
    [resetButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(button.mas_leading).with.offset(-5);
        make.top.equalTo(scrollView.mas_bottom).with.offset(20);
        make.size.mas_equalTo(NSMakeSize(120, 45));
    }];

    NSButton *inneerButton = [NSButton buttonWithTitle:@"使用内部配置" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(clickEvent:)];
    inneerButton.tag = 102;
    inneerButton.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    inneerButton.layer.cornerRadius = 4.0;
    inneerButton.layer.masksToBounds = YES;
    [self.view addSubview:inneerButton];
    [inneerButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(button.mas_trailing).with.offset(5);
        make.top.equalTo(scrollView.mas_bottom).with.offset(20);
        make.size.mas_equalTo(NSMakeSize(120, 45));
    }];

    NSButton *upButton = [NSButton buttonWithTitle:@"刷新按钮状态" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(refreshToolBarItem)];
    upButton.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    upButton.layer.cornerRadius = 4.0;
    upButton.layer.masksToBounds = YES;
    [self.view addSubview:upButton];
    [upButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(resetButton.mas_leading);
        make.top.equalTo(resetButton.mas_bottom).with.offset(20);
        make.size.mas_equalTo(NSMakeSize(120, 45));
    }];
}

- (NSDictionary *)defaultConfig {
    return @{
        @"toolBar": [self defaultToolBarItemConfig],
        @"shareBar": [self defaultShareItemConfig],
        @"shareBarMore": [self defaultShareBarMoreConfig],
        @"toolBarMore": [self defaultShareBarMoreConfig],
    };
}

- (NSArray *)defaultToolBarItemConfig {
    return @[
        @[@{ @"useDefaultConfig": @1,
             @"defaultConfig": @"defaultMicrophoneItem" },
          @{ @"useDefaultConfig": @1,
             @"defaultConfig": @"defaultSpeakerItem" },
          @{ @"useDefaultConfig": @1,
             @"defaultConfig": @"defaultCameraItem" },
        ],
        @[@{ @"useDefaultConfig": @1,
             @"defaultConfig": @"defaultSecurityItem" },
          @{ @"useDefaultConfig": @0,
             @"defaultConfig": @"defaultInvitationItem",
             @"imagePath": @"head_icon_0.png",
             @"title": @"修改后的标题",
             @"useCustomEvent": @1 },
          @{ @"useDefaultConfig": @1,
             @"defaultConfig": @"defaultChatItem" },
          @{ @"useDefaultConfig": @1,
             @"defaultConfig": @"defaultDataShareItem" },
          @{ @"useDefaultConfig": @1,
             @"defaultConfig": @"defaultMoreItem" },
          @{ @"useDefaultConfig": @0,
             @"defaultConfig": @"defaultRecordPauseModeItem",
             @"defaultImagePath": @"meeting_button_edit_normal",
             @"selectedImagePath": @"icon-customize-select-selected",
             @"imagePath": @"head_icon_0" },
          @{ @"useDefaultConfig": @0,
             @"title": @"普通状态",
//             @"selectedTitle": @"选中状态",
//             @"disabledTitle": @"禁用状态",
             @"type": @101,
             @"imagePath": @"head_icon_0",
//             @"selectedImagePath": @"icon-customize-select-selected",
             @"disabledImagePath": @"icon-customize-select-member",
//             @"selected": @"1",
             @"submenus": @[
                 @{ @"title": @"一级菜单1",
                    @"useDefaultConfig": @0,
                    @"useCustomEvent": @1 },
                 @{ @"title": @"一级菜单2",
                    @"useDefaultConfig": @0,
                    @"useCustomEvent": @1,
                    @"needSeperator": @1, },
                 @{ @"title": @"一级菜单3",
                    @"useDefaultConfig": @0,
                    @"useCustomEvent": @1,
                    @"submenus": @[
                        @{ @"title": @"二级菜单1",
                           @"useDefaultConfig": @0,
                           @"useCustomEvent": @1 },
                        @{ @"title": @"二级菜单2",
                           @"useDefaultConfig": @0,
                           @"useCustomEvent": @1,
                           @"needSeperator": @1, },
                        @{ @"title": @"二级菜单3",
                           @"useDefaultConfig": @0,
                           @"useCustomEvent": @1 },
                 ] },
             ],
             @"useCustomEvent": @1 },
        ],
        @[@{ @"useDefaultConfig": @1,
             @"defaultConfig": @"defaultLeaveItem" }
        ],
    ];
}

- (NSArray *)defaultShareItemConfig {
    return @[
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultMicrophoneItem" },
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultSpeakerItem" },
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultCameraItem" },
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultSecurityItem" },
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultChatItem" },
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultParticipantItem" },
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultMoreItem" },
        @{ @"useDefaultConfig": @0,
           @"title": @"自定义",
           @"imagePath": @"head_icon_0",
           @"selectedImagePath": @"head_icon_0",
           @"useCustomEvent": @1,
           @"type": @"102" },
    ];
}

- (NSArray *)defaultShareBarMoreConfig {
    return @[
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultSubtitleModel" },
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultFeedbackModel" },
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultNetworkDectectionModel" },
        @{ @"useDefaultConfig": @1,
           @"defaultConfig": @"defaultSmallPaneModel" },
        @{ @"useDefaultConfig": @0,
           @"themeLevel": @1,
           @"title": @"标题栏" },
        @{ @"useDefaultConfig": @0,
           @"allowSelected": @1,
           @"title": @"允许选中",
           @"imagePath": @"icon-customize-select-hover",
           @"selectedImagePath": @"/Users/apple/Desktop/head_icon_0.png", },
        @{ @"useDefaultConfig": @0,
           @"title": @"自定义",
           @"imagePath": @"icon-customize-select-hover",
           @"useCustomEvent": @1,
           @"submenus": @[
               @{ @"title": @"子选项1",
                  @"useDefaultConfig": @0,
                  @"useCustomEvent": @1 },
               @{ @"title": @"子选项2",
                  @"useDefaultConfig": @0,
                  @"useCustomEvent": @1,
                  @"needSeperator": @1, },
               @{ @"title": @"子选项3",
                  @"useDefaultConfig": @0,
                  @"useCustomEvent": @1 },
        ] },
    ];
}

- (NSString *)convertDictionaryToJsonString:(NSDictionary *)dictionary {
    if (![dictionary isKindOfClass:[NSDictionary class]] || ![NSJSONSerialization isValidJSONObject:dictionary]) {
        return nil;
    }
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dictionary options:NSJSONWritingPrettyPrinted|NSJSONWritingSortedKeys error:nil];
    NSString *strJson = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];

    return strJson;
}

- (void)clickEvent:(NSButton *)button {
    NSInteger index = button.tag - 100;
    [HWMToolBarConfigDataSource shareInstance].itemConfig = (HWMToolBarItemConfig)index;
    [HWMConsoleManager shareInstance].console = @[@"use default config", @"receive input data source", @"use inner config"][index];

    if (index != 1) {
        return;
    }
    if (!self.textView.string.length) {
        [HWMConsoleManager shareInstance].console = @"input config is empty";
    } else {
        NSData *data = [self.textView.string dataUsingEncoding:NSUTF8StringEncoding];
        if (data) {
            NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
            NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dic options:NSJSONWritingPrettyPrinted|NSJSONWritingSortedKeys error:nil];
            NSString *strJson = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
            self.textView.string = strJson;
            if (!dic) {
                [HWMConsoleManager shareInstance].console = @"param is nil,input config may be wrong";
            } else {
                [HWMConsoleManager shareInstance].console = @"config tool bar items successfully";
                HWMItemConfigModel *model = [HWMItemConfigModel yy_modelWithDictionary:dic];
                [HWMToolBarConfigDataSource shareInstance].configModel = model;
            }
        } else {
            [HWMConsoleManager shareInstance].console = @"param is nil,input config may be wrong";
        }
    }
}

- (void)refreshToolBarItem {
    [HWMConsoleManager shareInstance].console = @"refresh tool bar item";
    [[HWMSdk getOpenApi] updateCustomUIWithScene:HWMCustomUISceneToolBar];
}

@end
