//
//  HWMSelectContactViewCell.h
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/11.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <HWMUISDK/HWMUISDK.h>
#import "HWMContactInfoModel.h"

NS_ASSUME_NONNULL_BEGIN

@protocol HWMSelectContactViewCellDelegate <NSObject>

- (void)selectConstactStateChanged:(NSInteger)index;

@end

@interface HWMSelectContactViewCell : NSTableCellView

+ (instancetype)initSelectContactCell:(NSTableView *)tableView ower:(id)ower;

/// 数据源
@property (nonatomic, strong) HWMContactInfoModel *infoModel;
/// 选择
@property (nonatomic, assign) BOOL select;

@property (nonatomic, assign) NSInteger index;

///代理
@property (nonatomic, weak) id<HWMSelectContactViewCellDelegate> delegate;

@end

NS_ASSUME_NONNULL_END
