//
//  HWMSelectContactViewCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/11.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSelectContactViewCell.h"

@interface HWMSelectContactViewCell ()

/// 选择按钮
@property (nonatomic, strong) NSButton *contentBtn;

@end

@implementation HWMSelectContactViewCell

+ (instancetype)initSelectContactCell:(NSTableView *)tableView ower:(id)ower {
    HWMSelectContactViewCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMSelectContactViewCell class]) owner:ower];
    if (cell == nil) {
        cell = [[HWMSelectContactViewCell alloc] initWithFrame:NSZeroRect];
        cell.identifier = NSStringFromClass([HWMSelectContactViewCell class]);
    }
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];

    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.contentBtn];

    [self.contentBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self).offset(15);
        make.trailing.equalTo(self).offset(-15);
        make.centerY.equalTo(self);
    }];
}

#pragma mark - Event
- (void)selectAtendee:(NSButton *)sender {
    if (self.delegate && [self.delegate respondsToSelector:@selector(selectConstactStateChanged:)]) {
        [self.delegate selectConstactStateChanged:self.index];
    }
}

#pragma mark - Setter
- (void)setInfoModel:(HWMContactInfoModel *)infoModel {
    _infoModel = infoModel;
    NSMutableAttributedString *att = [[NSMutableAttributedString alloc] initWithString:infoModel.name];
    self.contentBtn.attributedTitle = att;
}

- (void)setSelect:(BOOL)select {
    _select = select;
    self.contentBtn.state = select ? NSControlStateValueOn : NSControlStateValueOff;
}

#pragma mark - Lazy

- (NSButton *)contentBtn {
    if (!_contentBtn) {
        _contentBtn = [NSButton buttonWithTitle:@"" font:nil fontColor:[NSColor colorWithRGB:0x333333] target:self action:@selector(selectAtendee:)];
        _contentBtn.buttonType = NSButtonTypeSwitch;
    }

    return _contentBtn;
}

@end
