//
//  HWMSwitchCell.h
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/28.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN
@protocol HWMSwitchCellDelegate <NSObject>

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index;

@end
@interface HWMSwitchCell : NSTableCellView

+ (instancetype)initSwitchCell:(NSTableView *)tableView ower:(nullable id)ower;

/// index
@property (nonatomic, assign) NSInteger index;
/// delegate
@property (nonatomic, weak) id<HWMSwitchCellDelegate> delegate;
/// 标题
@property (nonatomic, copy) NSString *title;
/// 状态
@property (nonatomic, assign) BOOL state;

@property (nonatomic, assign) BOOL enabled;

@end

NS_ASSUME_NONNULL_END
