//
//  HWMGlobalConfigController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/1/12.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMGlobalConfigController.h"
#import "HWMSDKTableView.h"
#import "HWMSwitchCell.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMTableCellArrowView.h"
#import "HWMConfigServerController.h"
#import "NSViewController+HWMNavigation.h"
#import "HWMSDKDemoFileManager.h"
#import "HWMSetRecordPathController.h"
#import "HWMSetProxyController.h"
#import "HWMSetNetworkModeController.h"
#import "HWMSetLogPathController.h"
#import "HWMSetGuaranteeIpAddrsViewController.h"
#import "HWMSetCAVerifyController.h"
#import "HWMConfigLinkPrefixController.h"
#import "HWMSetCustomTextViewController.h"
#import "HWMSetConfMgrGuaranteeIpAddrsViewController.h"
#import "HWMSetAvatarStyleController.h"
#import "HWMTransparentWindowController.h"

typedef NS_ENUM (NSInteger, HWMGlobalConfigCellType) {
    HWMGlobalConfigCellTypeHideExternalLabel = 0,   // 隐藏外部标签
    HWMGlobalConfigCellTypeHideAllowJoinConf,       // 隐藏允许入会
    HWMGlobalConfigCellTypeAudioRawData,            // 获取音频流
    HWMGlobalConfigCellTypeE2EE,                    // 端对端加密
    HWMGlobalConfigCellTypeShareScreen,             // 允许屏幕共享
    HWMGlobalConfigCellTypeShowMeetingAssistant,    // 显示会议助手
    HWMGlobalConfigCellTypeHideOfflineParticipant,  // 隐藏未入会与会者
    HWMGlobalConfigCellTypeConfigServer,            // 服务器设置
    HWMGlobalConfigCellTypeShowMeetingWindow,       // 返回会议
    HWMGlobalConfigCellTypeRecordPath,              // 设置本地录制路径
    HWMGlobalConfigCellTypeProxy,                   // 代理设置
    HWMGlobalConfigCellTypeNetworkMode,             // 网络模式设置
    HWMGlobalConfigCellTypeLogPath,                 // 日志路径设置
    HWMGlobalConfigCellTypeConfCtrlGuaranteeIpAddrs,// 设置(会控)保底ip地址
    HWMGlobalConfigCellTypeConfMgrGuaranteeIpAddrs, // 设置(管理面)保底ip地址
    HWMGlobalConfigCellTypeCAVerify,                // CA证书路径
    HWMGlobalConfigCellTypeAllowMeetingUt,          // 关闭SDK日志自动收集与上报会中打点
    HWMGlobalConfigCellTypeConfigLinkPrefix,        // 会议链接前缀
    HWMGlobalConfigCellTypeSetCustomText,           // 自定义场景文案
    HWMGlobalConfigCellTypeSetAvatarStyle,          // 自定义默认头像风格
    HWMGlobalConfigCellTypeTransparentWindow,       // 设置屏幕共享透明窗口
};

@interface HWMGlobalConfigController () <HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate, HWMSwitchCellDelegate, HWMBizNotificationHandler>

/// 标题
@property (nonatomic, copy) NSDictionary<NSNumber *, NSString *> *titleDic;
/// tableView
@property (nonatomic, strong) HWMSDKTableView *listView;

@property (nonatomic, assign) BOOL hasSharePermission;
@property (nonatomic, assign) BOOL showMeetingAssistant;
@property (nonatomic, assign) BOOL hideOfflineParticipant;
@property (nonatomic, assign) BOOL allowMeetingUt;

@end

@implementation HWMGlobalConfigController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupData];
    [self setupUI];
    [self setupDelegate];
}

#pragma mark - Data

- (void)setupData {
    self.titleDic = @{
        @(HWMGlobalConfigCellTypeHideExternalLabel) : @"隐藏外部标签",
        @(HWMGlobalConfigCellTypeHideAllowJoinConf) : @"隐藏允许入会",
        @(HWMGlobalConfigCellTypeAudioRawData) : @"获取音频流",
        @(HWMGlobalConfigCellTypeE2EE) : @"端对端加密",
        @(HWMGlobalConfigCellTypeShareScreen) : @"允许屏幕共享",
        @(HWMGlobalConfigCellTypeShowMeetingAssistant) : @"显示会议助手",
        @(HWMGlobalConfigCellTypeHideOfflineParticipant) : @"隐藏未入会与会者",
        @(HWMGlobalConfigCellTypeConfigServer) : @"服务器设置",
        @(HWMGlobalConfigCellTypeShowMeetingWindow) : @"返回会议",
        @(HWMGlobalConfigCellTypeRecordPath) : @"设置本地录制路径",
        @(HWMGlobalConfigCellTypeProxy) : @"代理设置",
        @(HWMGlobalConfigCellTypeNetworkMode) : @"网络模式设置",
        @(HWMGlobalConfigCellTypeLogPath) : @"日志路径设置",
        @(HWMGlobalConfigCellTypeConfCtrlGuaranteeIpAddrs) : @"设置(会控)保底ip地址",
        @(HWMGlobalConfigCellTypeConfMgrGuaranteeIpAddrs) : @"设置(管理面)保底ip地址",
        @(HWMGlobalConfigCellTypeCAVerify) : @"CA证书路径",
        @(HWMGlobalConfigCellTypeAllowMeetingUt) : @"关闭SDK日志自动收集与上报会中打点",
        @(HWMGlobalConfigCellTypeConfigLinkPrefix) : @"会议链接前缀",
        @(HWMGlobalConfigCellTypeSetCustomText) : @"自定义场景文案",
        @(HWMGlobalConfigCellTypeSetAvatarStyle) : @"自定义默认头像风格",
        @(HWMGlobalConfigCellTypeTransparentWindow) : @"设置屏幕共享透明窗口",
    };
    
    self.hasSharePermission = YES;
}

#pragma mark - UI

- (void)setupUI {
    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"globalConfig"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.and.top.equalTo(self.view).offset(15);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.view).offset(-15);
    }];
}

#pragma mark - Config delegate

- (void)setupDelegate {
    [[HWMSdk getSdkConfig] subscribeBizNotificationHandler:self];
}

#pragma mark - Delegate

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.titleDic.count;
}

- (BOOL)isSwitchCell:(HWMGlobalConfigCellType)type {
    if (type == HWMGlobalConfigCellTypeHideExternalLabel ||
        type == HWMGlobalConfigCellTypeHideAllowJoinConf ||
        type == HWMGlobalConfigCellTypeAudioRawData ||
        type == HWMGlobalConfigCellTypeE2EE ||
        type == HWMGlobalConfigCellTypeShareScreen ||
        type == HWMGlobalConfigCellTypeShowMeetingAssistant ||
        type == HWMGlobalConfigCellTypeHideOfflineParticipant ||
        type == HWMGlobalConfigCellTypeAllowMeetingUt) {
        return YES;
    }
    return NO;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    BOOL isSwitchCell = [self isSwitchCell:row];
    if (!isSwitchCell) {
        HWMTableCellArrowView *arrow = [HWMTableCellArrowView tableViewArrowCell:tableView ower:self];
        arrow.index = row;
        arrow.title = self.titleDic[@(row)];
        @weakify(self)
        [arrow setArrowCellViewClickHandler:^(NSInteger index) {
            @strongify(self)
            if (index == HWMGlobalConfigCellTypeConfigServer) {
                HWMConfigServerController *config = [[HWMConfigServerController alloc] init];
                [self.customNavigationController pushViewController:config animated:YES];
            } else if (index == HWMGlobalConfigCellTypeShowMeetingWindow) {
                [[HWMBizSdk getBizOpenApi] showMeetingWindow];
            } else if (index == HWMGlobalConfigCellTypeRecordPath) {
                if (![HWMSdk hasInit]) {
                    [HWMConsoleManager shareInstance].console = @"no init";
                    return;
                }
                HWMSetRecordPathController *recordPath = [[HWMSetRecordPathController alloc] init];
                [self.customNavigationController pushViewController:recordPath animated:YES];
            } else if (index == HWMGlobalConfigCellTypeProxy) {
                HWMSetProxyController *setProxy = [[HWMSetProxyController alloc] init];
                [self.customNavigationController pushViewController:setProxy animated:YES];
            } else if (index == HWMGlobalConfigCellTypeNetworkMode) {
                HWMSetNetworkModeController *setNetwork = [[HWMSetNetworkModeController alloc] init];
                [self.customNavigationController pushViewController:setNetwork animated:YES];
            } else if (index == HWMGlobalConfigCellTypeLogPath) {
                HWMSetLogPathController *logPath = [[HWMSetLogPathController alloc] init];
                [self.customNavigationController pushViewController:logPath animated:YES];
            } else if (index == HWMGlobalConfigCellTypeConfCtrlGuaranteeIpAddrs) {
                HWMSetGuaranteeIpAddrsViewController *ipAddrs = [[HWMSetGuaranteeIpAddrsViewController alloc] init];
                [self.customNavigationController pushViewController:ipAddrs animated:YES];
            } else if (index == HWMGlobalConfigCellTypeConfMgrGuaranteeIpAddrs) {
                HWMSetConfMgrGuaranteeIpAddrsViewController *ipAddrs = [[HWMSetConfMgrGuaranteeIpAddrsViewController alloc] init];
                [self.customNavigationController pushViewController:ipAddrs animated:YES];
            } else if (index == HWMGlobalConfigCellTypeCAVerify) {
                HWMSetCAVerifyController *CAVerify = [[HWMSetCAVerifyController alloc] init];
                [self.customNavigationController pushViewController:CAVerify animated:YES];
            } else if (index == HWMGlobalConfigCellTypeConfigLinkPrefix) {
                HWMConfigLinkPrefixController *configLinkPrefix = [[HWMConfigLinkPrefixController alloc] init];
                [self.customNavigationController pushViewController:configLinkPrefix animated:YES];
            } else if (index == HWMGlobalConfigCellTypeSetCustomText) {
                HWMSetCustomTextViewController *customText = [[HWMSetCustomTextViewController alloc] init];
                [self.customNavigationController pushViewController:customText animated:YES];
            } else if (index == HWMGlobalConfigCellTypeSetAvatarStyle) {
                HWMSetAvatarStyleController *avatarStyle = [[HWMSetAvatarStyleController alloc] init];
                [self.customNavigationController pushViewController:avatarStyle animated:YES];
            } else if (index == HWMGlobalConfigCellTypeTransparentWindow) {
                HWMTransparentWindowController *transparentWnd = [[HWMTransparentWindowController alloc] init];
                [self.customNavigationController pushViewController:transparentWnd animated:YES];
            }
        }];
        return arrow;
    }
    HWMSwitchCell *cell = [HWMSwitchCell initSwitchCell:tableView ower:self];
    cell.index = row;
    cell.title = self.titleDic[@(row)];
    cell.delegate = self;
    if (row == HWMGlobalConfigCellTypeHideExternalLabel) {
        cell.state = [[HWMSdk getSdkConfig] hideExternalLabel];
    } else if (row == HWMGlobalConfigCellTypeShareScreen) {
        cell.state = self.hasSharePermission;
    } else if (row == HWMGlobalConfigCellTypeShowMeetingAssistant) {
        cell.state = self.showMeetingAssistant;
    } else if (row == HWMGlobalConfigCellTypeHideOfflineParticipant) {
        cell.state = self.hideOfflineParticipant;
    } else if (row == HWMGlobalConfigCellTypeAllowMeetingUt) {
        cell.state = self.allowMeetingUt;
    }
    return cell;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 40.0;
}

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    HWMSwitchCell *cell = [self.listView.listView viewAtColumn:0 row:index makeIfNecessary:NO];
    if ([HWMSdk hasInit]) {
        if (index == HWMGlobalConfigCellTypeHideExternalLabel) {
            [[HWMSdk getSdkConfig] setHideExternalLabel:state];
        } else if (index == HWMGlobalConfigCellTypeHideAllowJoinConf) {
            [[HWMSdk getSdkConfig] setHideAllowJoinConfMenu:state];
        } else if (index == HWMGlobalConfigCellTypeAudioRawData) {
            [[HWMBizSdk getBizOpenApi] setAudioRawDataOutputConfig:state];
        } else if (index == HWMGlobalConfigCellTypeE2EE) {
            if (state) {
                [HWMConsoleManager shareInstance].console = @"open e2ee";
            } else {
                [HWMConsoleManager shareInstance].console = @"close e2ee";
            }
            [[HWMSdk getOpenApi] enableE2EE:state];
        } else if (index == HWMGlobalConfigCellTypeShareScreen) {
            self.hasSharePermission = state;
            [[HWMSdk getOpenApi] setShareScreenPermission:state];
        } else if (index == HWMGlobalConfigCellTypeShowMeetingAssistant) {
            self.showMeetingAssistant = state;
            [[HWMSdk getOpenApi] supportMeetingAssistant:state];
        }  else if (index == HWMGlobalConfigCellTypeHideOfflineParticipant) {
            self.hideOfflineParticipant = state;
            [HWMSdk getSdkConfig].hideOfflineParticipant = state;
        } else if (index == HWMGlobalConfigCellTypeAllowMeetingUt) {
            self.allowMeetingUt = state;
            [[HWMBizSdk getBizOpenApi] setAllowMeetingUt:!state];
        }
    } else {
        cell.state = NO;
        if (index == HWMGlobalConfigCellTypeHideExternalLabel) {
            cell.state = [[HWMSdk getSdkConfig] hideExternalLabel];
        } else if (index == HWMGlobalConfigCellTypeShareScreen) {
            cell.state = self.hasSharePermission;
        } else if (index == HWMGlobalConfigCellTypeShowMeetingAssistant) {
            cell.state = self.showMeetingAssistant;
        } else if (index == HWMGlobalConfigCellTypeHideOfflineParticipant) {
            cell.state = self.hideOfflineParticipant;
        }
        [HWMConsoleManager shareInstance].console = @"no init";
    }
}

- (void)onAudioFrameDataNotify:(HWMAudioFrameDataModel *)pFrame {
    NSString *pcmPath = [NSString stringWithFormat:@"%@/audio_reocd.pcm", [HWMSDKDemoFileManager pcmPath]];
    FILE *_fb;
    _fb = fopen(pcmPath.UTF8String, "ab+");
    if (_fb && pFrame.pBuffer.length > 0) {
        size_t bufferL = pFrame.iSamples * pFrame.iBytesPerSample * pFrame.iChannels;
        fwrite(pFrame.pBuffer.bytes, 1, bufferL, _fb);
        fclose(_fb);
    }
}

@end
