//
//  HWMSetConfInfoController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2025/6/23.
//  Copyright © 2025 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetConfInfoController.h"
#import "HWMSocialView.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMSetConfInfoController () <HWMBizNotificationHandler, HWMShowSocialShareHandler>

@property (nonatomic, strong) NSButton *defaultButton;
@property (nonatomic, strong) NSButton *customButton;
@property (nonatomic, strong) HWMSocialView *socialView;

@end

@implementation HWMSetConfInfoController

- (void)dealloc {
    [[HWMSdk getSdkConfig] unsubscribeBizNotificationHandler:self];
}

- (void)viewWillAppear {
    [super viewWillAppear];
    /// 订阅要在初始化后根据需要设置
    [[HWMSdk getSdkConfig] subscribeBizNotificationHandler:self];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

- (void)setupUI {
    self.defaultButton = [NSButton buttonWithTitle:@"默认" target:self action:@selector(buttonClicked:) stateValueOn:YES];
    [self.view addSubview:self.defaultButton];
    [self.defaultButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(@120);
        make.leading.mas_equalTo(200);
    }];
    
    self.customButton = [NSButton buttonWithTitle:@"自定注入" target:self action:@selector(buttonClicked:) stateValueOn:NO];
    [self.view addSubview:self.customButton];
    [self.customButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(self.defaultButton);
        make.trailing.mas_equalTo(-200);
    }];
}

- (void)buttonClicked:(NSButton *)btn {
    BOOL isCustom = self.defaultButton.state == NSControlStateValueOff;
    [HWMSdk getSdkConfig].showSocialShareHandler = isCustom ? self : nil;
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"set conf info is %@", isCustom ? @"custom " : @"default"];
}

- (HWMSocialView *)socialView {
    if (!_socialView) {
        _socialView = [[HWMSocialView alloc] initWithFrame:NSMakeRect(0, 0, 500, 300)];
        _socialView.wantsLayer = YES;
        _socialView.layer.backgroundColor = [NSColor whiteColor].CGColor;
    }
    return _socialView;
}

/// 会中鼠标移至标题栏出现的分享View
- (NSView *)socialShareView:(HWMSDKMeetingInfoModel *)meetingInfo {
    self.socialView.meetingInfo = meetingInfo;
    return self.socialView;
}

/// 会议基本信息
- (void)onMeetingInfoChanged:(HWMSDKMeetingInfoModel *)meetingInfo {
    self.socialView.meetingInfo = meetingInfo;
}

@end
