//
//  HWMToastAndMainViewSizeController.m
//  HWMUISDKNativeDemo
//
//  Created by guoyongliang/g30033086 on 2023/10/8.
//  Copyright © 2023 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMToastAndMainViewSizeController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMInputView.h"

@interface HWMToastAndMainViewSizeController ()

@property (nonatomic, strong) HWMInputView *toastContentView;
@property (nonatomic, strong) HWMInputView *toastDurationInfoView;
@property (nonatomic, strong) NSButton *toastBtn;
@property (nonatomic, strong) NSButton *mainViewBtn;
@end

@implementation HWMToastAndMainViewSizeController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

- (void)setupUI {
    [self.view addSubview:self.toastContentView];
    [self.view addSubview:self.toastDurationInfoView];
    
    [self.toastContentView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(30);
        make.width.mas_equalTo(300);
    }];
    
    [self.toastDurationInfoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.toastContentView.mas_bottom).offset(10);
        make.leading.equalTo(self.toastContentView);
        make.size.equalTo(self.toastContentView);
    }];
    
    self.toastBtn = [self creatbButtonWithTitle:@"toast提示" tag:0];
    [self.view addSubview:self.toastBtn];
    [self.toastBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self.view.mas_centerX).offset(-100);
        make.top.equalTo(self.toastDurationInfoView.mas_bottom).offset(50);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(160);
    }];
    
    self.mainViewBtn = [self creatbButtonWithTitle:@"获取主窗口大小" tag:1];
    [self.view addSubview:self.mainViewBtn];
    [self.mainViewBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.view.mas_centerX).offset(100);
        make.top.equalTo(self.toastBtn);
        make.size.equalTo(self.toastBtn);
    }];
    
}

- (NSButton *)creatbButtonWithTitle:(NSString *)title tag:(NSInteger)tag {
    NSButton *button = [NSButton buttonWithTitle:title font:nil fontColor:[NSColor whiteColor] target:self action:@selector(buttonEvent:)];
    button.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    button.layer.cornerRadius = 4.0;
    button.layer.masksToBounds = YES;
    button.tag = tag;
    return button;
}

- (void)buttonEvent:(NSButton *)button {
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }
    if (button.tag == 0) {
        HWMUISDKToastInfoModel * info = [[HWMUISDKToastInfoModel alloc] init];
        info.content = self.toastContentView.textField.stringValue;
        info.duration = self.toastDurationInfoView.textField.intValue;
        [[HWMBizSdk getBizOpenApi] showToast:info];
        [HWMConsoleManager shareInstance].console = @"toast提示";
    } else if (button.tag == 1) {
        HWMUISDKMainWindowInfoModel * info = [[HWMBizSdk getBizOpenApi] getMainWindowInfo];
        [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"获取窗口大小: x:%zd, y:%zd, width:%zd, height:%zd, handle:%zd", info.x, info.y, info.width, info.height, info.handle];
    }
}


- (HWMInputView *)toastContentView {
    if (!_toastContentView) {
        _toastContentView = [[HWMInputView alloc] init];
        _toastContentView.title = @"toast内容:";
        _toastContentView.placeholder = @"请输入toast内容";
    }
    return _toastContentView;
}

-(HWMInputView *)toastDurationInfoView {
    if (!_toastDurationInfoView) {
        _toastDurationInfoView = [[HWMInputView alloc] init];
        _toastDurationInfoView.title = @"toast显示时间:";
        _toastDurationInfoView.placeholder = @"请输入toast显示时间";
    }
    return _toastDurationInfoView;
}


@end
