//
//  HWMMainPageNavigationView.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/24.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMMainPageNavigationView.h"

@interface HWMMainPageNavigationView ()

@property (nonatomic, strong) NSTextField *titleLabel;

@end

@implementation HWMMainPageNavigationView

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    self.wantsLayer = YES;
    self.layer.backgroundColor = [NSColor whiteColor].CGColor;
    self.layer.borderColor = [NSColor colorWithRGB:0xEEEEEE].CGColor;
    self.layer.borderWidth = 1.0;
    
    [self addSubview:self.titleLabel];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self);
    }];
}

#pragma mark - Lazy

- (NSTextField *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [NSTextField hwm_fieldWithTitle:@"HWMUI SDK Demo" titleColor:[NSColor colorWithRGB:0x333333] font:[NSFont systemFontOfSize:14]];
    }
    return _titleLabel;
}

@end
