//
//  HWMParticipantListHandler.h
//  HWMUISDK
//
//  Created by linweiqiang on 2022/5/23.
//  Copyright © 2022 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMUISDKInjectParticipantItemBtnInfoModel.h"
#import "HWMUISDKCallAllBtnInfoModel.h"

NS_ASSUME_NONNULL_BEGIN

@protocol HWMParticipantListHandler <NSObject>

@optional

/// [en] Notify of inject participant item btn. [cn] 与会者列表子项注入点击通知
- (void)onClickInjectParticipantItemBtnNotify:(HWMUISDKInjectParticipantItemBtnInfoModel *)injectBtnInfo;
/// [en] Notify of inject recall btn. [cn] 重新呼叫注入点击通知
- (void)onClickInjectRecallBtnNotify:(HWMUISDKInjectParticipantItemBtnInfoModel *)injectBtnInfo;
/// [en] Notify of inject Call all btn. [cn] 全部呼叫注入点击通知
- (void)onClickInjectCallAllBtnNotify:(HWMUISDKCallAllBtnInfoModel *)injectBtnInfo;
/// [en] Notify of double click participant list item [cn] 双击与会者项通知
- (void)onDoubleClickParticipantListItemNotify:(HWMUISDKParticipantItemInfoModel *)participantInfo;

@end

NS_ASSUME_NONNULL_END
