//
//  HWMItemModel.h
//  HWMUISDK
//
//  Created by tyfinal on 2021/6/25.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

@class HWMMenuItemModel;
@interface HWMToolBarItemModel : NSObject

/// 普通标题
@property (nonatomic, copy) NSString *title;
/// 初始按钮标题 点击按钮时会显示title
@property (nonatomic, copy, nullable) NSString *defaultTitle;
/// 按钮选中时的标题 不设置则与正常状态下一致
@property (nonatomic, copy, nullable) NSString *selectedTitle;
/// 按钮不可操作时的标题 不设置则与正常状态下一致
@property (nonatomic, copy, nullable) NSString *disabledTitle;

/// 普通状态下的按钮图标
@property (nonatomic, strong) NSImage *iconImage;
/// 初始默认图片(可选)  点击会切换到normal状态图片
@property (nonatomic, strong, nullable) NSImage *defaultIconImage;
/// 按钮选中时的图标  不设置则与正常状态下一致
@property (nonatomic, strong, nullable) NSImage *selectedIconImage;
/// 按钮不可操作时的图标
@property (nonatomic, strong, nullable) NSImage *disabledIconImage;
/// 锁定状态下按钮图标 (针对共享 聊天 与会者锁定状态)
@property (nonatomic, strong, nullable) NSImage *lockIconImage;
/// 初始选中状态 默认为NO
@property (nonatomic, assign) BOOL selected;
/// 可选 作为按钮标识 不传默认为HWMToolBarItemTypeNone 前0~100为内部保留项 自定义项从101开始
@property (nonatomic, assign) HWMToolBarItemType ctrlType;
/// 点击item弹出菜单所需的数据源
@property (nonatomic, strong, nullable) NSArray <HWMMenuItemModel *> *submenus;
/// 点击按钮触发的事件回调
@property (nonatomic, copy, nullable) void(^ClickItemCallback)(HWMToolBarItemType ctrlType);

/// 安全
+ (instancetype)defaultSecurityItem;
/// 邀请
+ (instancetype)defaultInvitationItem;
/// 与会者
+ (instancetype)defaultParticipantItem;
/// 共享
+ (instancetype)defaultDataShareItem;
/// 聊天
+ (instancetype)defaultChatItem;
/// 同声传译
+ (instancetype)defaultInterpretation;
/// 录制
+ (instancetype)defaultRecordModeItem;
/// 会控工具栏更多
+ (instancetype)defaultMoreItem;
/// 共享工具栏更多
+ (instancetype)defaultShareMoreItem;
/// 离开
+ (instancetype)defaultLeaveItem;
/// 挂断
+ (instancetype)defaultHangupItem;
/// 观众分享
+ (instancetype)defaultAudienceShareItem;
/// 麦克风
+ (instancetype)defaultMicrophoneItem;
/// 扬声器
+ (instancetype)defaultSpeakerItem;
/// 摄像头
+ (instancetype)defaultCameraItem;
/// 观看
+ (instancetype)defaultWatchItem;
/// 举手
+ (instancetype)defaultHandUpItem;
/// 投票
+ (instancetype)defaultVoteItem;

@end

NS_ASSUME_NONNULL_END
