//
//  HWMConfIncomingInfo.h
//  HWMUISDK
//
//  Created by guomeng on 2021/12/16.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMConfIncomingInfo : NSObject

/// 呼叫类型
@property (nonatomic, assign) HWMSDKConfMediaType mediaType;
/// 呼叫状态
@property (nonatomic, assign) HWMConfIncomingState state;
/// 是否立即会议
@property (nonatomic, assign) BOOL isP2PConf;
/// 第三方用户帐号
@property (nonatomic, copy) NSString *thirdUserId;
/// 会议id
@property (nonatomic, copy) NSString *confId;
/// vmr会议id
@property (nonatomic, copy) NSString *vmrConfId;
/// 邀请者的姓名 自动邀请时同schedule
@property (nonatomic, copy) NSString *inviteName;
/// 邀请者的中文别名 自动邀请时同schedulerAliasCN
@property (nonatomic, copy) NSString *inviteAliasCN;
/// 邀请者的英文别名 自动邀请时同schedulerAliasEN
@property (nonatomic, copy) NSString *inviteAliasEN;
/// 三方自定义字段
@property (nonatomic, copy) NSString *inviteExtendedField;
/// 邀请者企业id
@property (nonatomic, copy) NSString *inviteCorpId;
/// 预订者姓名
@property (nonatomic, copy) NSString *schedulerName;
/// 预订者中文别名
@property (nonatomic, copy) NSString *schedulerAliasCN;
/// 预订者英文别名
@property (nonatomic, copy) NSString *schedulerAliasEN;
/// 三方自定义字段
@property (nonatomic, copy) NSString *schedulerExtendedField;

@end

NS_ASSUME_NONNULL_END
