//
//  HWMLocalRecordConst.h
//  HWMNativeSDK
//
//  Created by y00450113 on 2022/3/16.
//

#ifndef HWMLocalRecordConst_h
#define HWMLocalRecordConst_h
typedef NS_ENUM(NSUInteger, HWMLocalRecordErrorCode) {
    HWMLocalRecordErrorCodeIdle,  //  原始状态
    HWMLocalRecordErrorCodeCreateWriterError,  //  创建writer失败，出错
    HWMLocalRecordErrorCodeSetAudioInputError,  //  设置writer 的audio input 失败
    HWMLocalRecordErrorCodeSetVideoInputError,  //  设置writer 的video input 失败
    HWMLocalRecordErrorCodeAssetWriterStartError,  //  开启writer 失败
    HWMLocalRecordErrorCodeWriteInputAppendError,  //  写数据失败，根据经验，这种失败无法自动恢复，所以提示用户重试
    HWMLocalRecordErrorCodeRecordFileNotExist,  //  本地录制文件被删除
    
};
typedef NS_ENUM(NSUInteger, HWMLocalRecordEventCode) {
    HWMLocalRecordEventCodeSuccess,  // 成功
    HWMLocalRecordEventCodeFileUrlStartAccess, //文件URL开启访问
    HWMLocalRecordEventUpdateHistorySuccess, // 录制完成后更新历史会议记录成功
    HWMLocalRecordEventUpdateHistoryFail, //录制完成后更新历史会议记录失败
    HWMLocalRecordEventCodeCreateWriterStart, // 开始创建编码器writer
    HWMLocalRecordEventCodeCreateWriterSuccess, // 创建编码器writer 成功
    HWMLocalRecordEventCodeRegisterStreamNotify, // 注册监听SDK流事件通知
    HWMLocalRecordEventCodeReleaseStreamNotify, // 释放监听SDK流事件通知
    HWMLocalRecordEventCodeStartWhiteRender, // 开始渲染白板
    HWMLocalRecordEventCodeStopWhiteRender, // 停止渲染白板
    HWMLocalRecordEventCodeReceiveLocalRecordStateChanged, // 本地录制操作状态变更：开始，暂停，继续，停止
    HWMLocalRecordEventCodeAudioSampleErrorCount, // audio码流失败次数.包括获取到码流后，转sample异常等，在录制完成后上报
    HWMLocalRecordEventCodeVideoSampleErrorCount, // audio码流失败次数.包括获取到码流后，转pixbuffer异常，在录制完成后上报
    HWMLocalRecordEventCodeImageFrameInvalidCount, // 收到的图片流不合法。
    HWMLocalRecordEventCodeDataFrameInvalidCount, // 收到的数据流不合法。
    HWMLocalRecordEventCodeWriterStartSuccess, //开启 asset writer成功
    HWMLocalRecordEventCodeFrameDurationZero, //码流计算的时间duration为0
    HWMLocalRecordEventCodeFrameTimeScaleZero, //码流计算的时间scale为0
    HWMLocalRecordEventCodeNotReadyForMoreData, //写码流数据的时候，编码器还没有准备好
    HWMLocalRecordErrorCodeAssetWritingStatusError, //asset 写过程中状态错误
    HWMLocalRecordEventCodeFinishingStatusError, //完成的时候，asset writer 状态错误
    HWMLocalRecordEventCodeWriterReleased, // 录制完成，writer 被释放
};

typedef NS_ENUM(NSUInteger, HWMLocalRecordStopType) {
    HWMLocalRecordStopTypeNormal, // 正常结束
    HWMLocalRecordStopTypeAppTerminate, // 杀进程导致的结束录制
    HWMLocalRecordStopTypeOverTimeLimit // 超过3小时时间限制导致的结束
};
#endif /* HWMLocalRecordConst_h */
