//
//  HWMUISDKLoginService.h
//  HWMSDKSDK
//
//  Automatically generated file. DO NOT MODIFY!!!
//

#import <Foundation/Foundation.h>
#import "HWMUISDKCommonDefine.h"
#import "HWMUISDKAllModelIndex.h"

#import "HWMUISDKPrivateMeetingService.h"

NS_ASSUME_NONNULL_BEGIN

typedef void(^HWMSDKLoginByAccountHandler) (NSError * _Nullable error, HWMUISDKLoginResultModel * loginResult);

typedef void(^HWMSDKLoginByAppIdHandler) (NSError * _Nullable error, HWMUISDKLoginResultModel * loginResult);

typedef void(^HWMSDKLoginBySSOHandler) (NSError * _Nullable error, HWMUISDKLoginResultModel * loginResult);

typedef void(^HWMSDKLogoutHandler) (NSError * _Nullable error, HWMUISDKLogoutResultModel * logoutResult);

typedef void(^HWMSDKUploadSelfAvatarHandler) (NSError * _Nullable error);

typedef void(^HWMSDKSetCAVerifyInfoHandler) (NSError * _Nullable error);

typedef void(^HWMSDKSetGlobalGuaranteedIpAddressesHandler) (NSError * _Nullable error);


@protocol HWMUISDKLoginNotify <NSObject>

@optional
/// [en] Notify of be kicked out. [cn] 登录被踢通知
- (void)onKickedOutNotify;
/// [en] Notify of the config of corporation. [cn] 企业配置通知
- (void)onCorpConfigNotify:(HWMUISDKCorpConfigInfoModel *)configInfo;
/// [en] Notify of the info of corporation. [cn] 客户企业信息变化通知
- (void)onUserCorpInfoChanged:(HWMUISDKUserCorpInfoNotifyType)type;
/// [en]This is about login error notify. [cn]登录错误通知
- (void)onLoginErrorNotify:(HWMUISDKSDKERR)ret reason:(NSString *)reason;
/// [en]This is about share vmr info notify. [cn]共享vmr信息通知
- (void)onShareVmrInfoNotify:(HWMUISDKShareVmrInfoModel *)shareVmrInfo;
/// [en]This is about login state change notify. [cn]登录状态变化通知
- (void)onLoginStateChangeNotify:(HWMUISDKLoginStateInfoModel *)loginStateInfo;

@end

@interface HWMUISDKLoginService : NSObject

+ (instancetype)shareInstance;
+ (void)releaseInstance;
- (void)addLoginNotifyCallback:(id<HWMUISDKLoginNotify>)callback;
- (void)removeLoginNotifyCallback:(id<HWMUISDKLoginNotify>)callback;
/// [en] This interface is used to login by account info. [cn] 账号密码登录
- (void)loginWithAccountAuthInfo:(HWMUISDKAccountAuthInfoModel *)accountAuthInfo callback:(HWMSDKLoginByAccountHandler)callback;

/// [en] This interface is used to login by appId info. [cn] AppId登录
- (void)loginWithAppIdAuthInfo:(HWMUISDKAppIdAuthInfoModel *)appIdAuthInfo callback:(HWMSDKLoginByAppIdHandler)callback;

/// [en] This method is used to login by SSO. [cn] SSO登录
- (void)loginWithSsoAuthInfo:(HWMUISDKSSOAuthInfoModel *)ssoAuthInfo callback:(HWMSDKLoginBySSOHandler)callback;

/// [en] This interface is used to logout sdk. [cn] 退出登录
- (void)logoutWithCallback:(HWMSDKLogoutHandler)callback;

/// [en] This interface is used to set network mode. [cn] 设置网络模式
- (void)setNetworkModeWithInfo:(HWMUISDKNetWorkModeInfoModel *)info;

/// [en] This interface is used to upload self avatar. [cn] 上传头像
- (void)uploadSelfAvatarWithInfo:(HWMUISDKSelfAvatarInfoModel *)info callback:(HWMSDKUploadSelfAvatarHandler)callback;

/// [en] This interface is used to set guaranteed ip addresses. [cn] 设置(会控)保底ip地址
- (HWMUISDKSDKERR)setGuaranteedIpAddresses:(NSString *)guaranteedIpAddresses;

/// [en] This interface is used to set guaranteed ip addresses of global domain. [cn] 设置管理面域名对应的保底ip地址
- (void)setGlobalGuaranteedIpAddressesWithParam:(HWMUISDKGuaranteedIpAddressesParamModel *)param callback:(HWMSDKSetGlobalGuaranteedIpAddressesHandler)callback;

/// [en] This interface is used to set login server info. [cn] 设置登录服务器信息
- (void)setServerAddressWithInfo:(HWMUISDKServerInfoModel *)info;

/// [en] This interface is used to set proxy info. [cn] 设置代理信息
- (void)setProxyWithInfo:(HWMUISDKProxyInfoModel *)info;

/// [en] This interface is used to set CA verify info. [cn] 设置证书校验信息
- (void)setCAVerifyInfo:(HWMUISDKCAVerifyInfoModel *)info callback:(HWMSDKSetCAVerifyInfoHandler)callback;

/// [en] This interface is used to get login state. [cn] 获取登录状态
- (HWMUISDKLoginStateInfoModel *)getLoginState;

/// [en] This interface is used to get login token. [cn] 获取登录token
- (HWMUISDKLoginTokenInfoModel *)getLoginToken;

@end



NS_ASSUME_NONNULL_END

