//
//  AppDelegate.m
//  HWMUISDKNativeDemo
//
//  Created by HuLinjie on 2020/10/20.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "AppDelegate.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMMainPageWindowController.h"

@interface AppDelegate ()<HWMConfSettingHandler>
@property (nonatomic, strong) HWMMainPageWindowController *pageWindowVC;
@end

@implementation AppDelegate

- (void)applicationWillFinishLaunching:(NSNotification *)notification {
    [[NSAppleEventManager sharedAppleEventManager] setEventHandler:self andSelector:@selector(handleURLEvent:withReplyEvent:) forEventClass:kInternetEventClass andEventID:kAEGetURL];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification {
    // Insert code here to initialize your application

    [self showWindow];
}

- (void)applicationWillTerminate:(NSNotification *)aNotification {
    // Insert code here to tear down your application
}

/// 会议、点对点 来电时是否打开麦克风
- (BOOL)isOpenMicrophoneIncoming
{
    return NO;
}

/// 会议、点对点 来电时是否打开摄像头
- (BOOL)isOpenCameraIncoming
{
    return NO;
}

- (void)showWindow
{
    HWMMainPageWindowController *defaultWindowController =  [[HWMMainPageWindowController alloc] init];
    NSWindow *defaultWindow = [defaultWindowController createDefaultWindow];
    [defaultWindowController setWindow:defaultWindow];
    [defaultWindow makeKeyWindow];
    [defaultWindowController showWindow:nil];
    self.pageWindowVC = defaultWindowController;
}

- (void)handleURLEvent:(NSAppleEventDescriptor *)theEvent withReplyEvent:(NSAppleEventDescriptor *)replyEvent {
    
    NSString *urlString = [[theEvent paramDescriptorForKeyword:keyDirectObject] stringValue];
    if (urlString.length != 0 || urlString != nil) {
        [[NSNotificationCenter defaultCenter] postNotificationName:@"com.huawei.uisdkdemo.linkConf" object:urlString];
    }
}

@end
