//
//  HWMConsoleManager.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/24.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMConsoleManager.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMConsoleManager ()

/// 历史记录
@property (nonatomic, strong) NSMutableString *hisConsole;

@end

@implementation HWMConsoleManager

+ (instancetype)shareInstance {
    static dispatch_once_t onceToken;
    static HWMConsoleManager *manager = nil;
    dispatch_once(&onceToken, ^{
        manager = [[self alloc] init];
        manager.hisConsole = [[NSMutableString alloc] init];
    });
    return manager;
}

- (void)setConsole:(NSString *)console {
    _console = console;
    NSDate *date = [NSDate date];
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    formatter.dateFormat = @"yyyy-MM-dd HH:mm:ss";
    NSString *dateStr = [formatter stringFromDate:date];
    [self.hisConsole appendFormat:@"\n %@ %@", dateStr, console];
    self.consoleView.console = self.hisConsole;
}

- (void)setError:(NSError *)error {
    NSDate *date = [NSDate date];
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    formatter.dateFormat = @"yyyy-MM-dd HH:mm:ss";
    NSString *dateStr = [formatter stringFromDate:date];
    NSMutableString *string = [[NSMutableString  alloc] init];
    [string appendString:dateStr];
    [string appendString:@"\n"];
    NSString *errorTips = [[HWMBizSdk getBizOpenApi] getErrorMessage:error.code];
    if (errorTips && errorTips.length > 0) {
        [string appendFormat:@"%@\n", errorTips];
    }
    [string appendFormat:@"错误码:%lu \n", error.code];
    [string appendFormat:@"错误描述:%@", error.localizedDescription];
    [self.hisConsole appendFormat:@"\n %@", string];
    self.consoleView.console = self.hisConsole;
    NSAlert *alert = [[NSAlert alloc]init];
    alert.window.title = @"提示";
    alert.messageText = string;
    alert.alertStyle = NSAlertStyleWarning;
    [alert setInformativeText:@""];
    [alert addButtonWithTitle:@"确定"];
    [alert runModal];
}

@end
