//
//  HWMNavigationController.h
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/2.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

@interface HWMNavigationController : NSViewController

@property (nonatomic, strong, readonly) NSViewController *rootVC;

@property (nonatomic, strong, readonly) NSArray<NSViewController *> *viewControllers;

- (instancetype)initWithRootViewController:(nonnull NSViewController *)rootViewController;
- (void)pushViewController:(nullable NSViewController *)viewController animated:(BOOL)animated;
- (void)pushViewController:(nullable NSViewController *)viewController animated:(BOOL)animated completeBlock:(void(^)(void))block;
- (void)popViewControllerAnimated:(BOOL)animated;
- (void)popToViewController:(NSViewController *)destinationViewController animated:(BOOL)animated;
- (void)popToRootViewControllerAnimated:(BOOL)animated;

@end

NS_ASSUME_NONNULL_END
