//
//  HWMNavigationItem.h
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/2.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

@interface HWMNavigationItem : NSView

@property (nonatomic, strong, readonly) NSView *view;

@property (nonatomic, weak) id target;
@property (nonatomic, assign) SEL action;

///下面两个属性设置，需要写在 viewWillAppear
@property (nonatomic, copy) NSString *backTitle;
@property (nonatomic, strong) NSImage *backImage;


+ (instancetype)itemWithCustomView:(nonnull NSView *)view;

+ (instancetype)itemWithTitle:(NSString *)title color:(NSColor *)color image:(nullable NSImage *)image target:(id)target action:(SEL)action;

@end

NS_ASSUME_NONNULL_END
