//
//  NSViewController+HWMNavigation.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/2.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "NSViewController+HWMNavigation.h"
#import <objc/runtime.h>

@implementation NSViewController (HWMNavigation)

- (HWMNavigationController *)customNavigationController {
    NSViewController *vc = self.parentViewController;
    if ([vc isKindOfClass:[HWMNavigationController class]]) {
        HWMNavigationController *nav = (HWMNavigationController *)vc;
        if ([nav.viewControllers containsObject:self]) {
            return (HWMNavigationController *)vc;
        }
    }
    return nil;
}

- (HWMNavigationBar *)customNavigationBar {
    for (NSInteger index = self.view.subviews.count - 1; index >= 0; index--) {
        HWMNavigationBar *navBar = self.view.subviews[index];
        if ([navBar isKindOfClass:[HWMNavigationBar class]]) {
            return navBar;
        }
    }
    return nil;
}

- (void)setBackItem:(HWMNavigationItem *)backItem {
    objc_setAssociatedObject(self, @selector(backItem), backItem, OBJC_ASSOCIATION_RETAIN);
    self.customNavigationBar.backItem = backItem;
}

- (HWMNavigationItem *)backItem {
    return objc_getAssociatedObject(self, _cmd);
}

- (void)setHideNavBarWhenPush:(BOOL)hideNavBarWhenPush {
    objc_setAssociatedObject(self, @selector(hideNavBarWhenPush), @(hideNavBarWhenPush), OBJC_ASSOCIATION_ASSIGN);
}

- (BOOL)hideNavBarWhenPush {
    return [objc_getAssociatedObject(self, _cmd) boolValue];
}

@end
