//
//  HWMInputView.h
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/26.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "HWMTextField.h"
NS_ASSUME_NONNULL_BEGIN

@protocol HWMInputViewDelegate <NSObject>

- (void)textFieldDidChanged:(NSTextField *)field;

@end

@interface HWMInputView : NSView

/// 输入框
@property (nonatomic, strong) HWMTextField *textField;
/// 标题
@property (nonatomic, copy) NSString *title;
/// 预留字
@property (nonatomic, copy) NSString *placeholder;
/// 代理
@property (nonatomic, weak) id<HWMInputViewDelegate> delegate;

@end

NS_ASSUME_NONNULL_END
