//
//  HWMAttendeeListInjectClickItemController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2025/2/12.
//  Copyright © 2025 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMAttendeeListInjectClickItemController.h"
#import "HWMSwitchCell.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMAttendeeListInjectClickItemController () <HWMSwitchCellDelegate, HWMParticipantListHandler>

@property (nonatomic, strong) HWMSwitchCell *clickItemSwitchCell;
@property (nonatomic, assign) BOOL clickItemSwitchState;
@property (nonatomic, strong) NSTextField *clickInjectParticipantItemBtn;
@property (nonatomic, strong) NSTextField *clickInjectRecallBtn;
@property (nonatomic, strong) NSTextField *clickInjectCallAllBtn;
@property (nonatomic, strong) NSTextField *doubleClickParticipantListItem;

@end

@implementation HWMAttendeeListInjectClickItemController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - HWMParticipantListHandler

- (void)onClickInjectParticipantItemBtnNotify:(HWMUISDKInjectParticipantItemBtnInfoModel *)injectBtnInfo {
    NSString *info = [injectBtnInfo yy_modelDescription];
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"participant: %@", info];
}

- (void)onClickInjectRecallBtnNotify:(HWMUISDKInjectParticipantItemBtnInfoModel *)injectBtnInfo {
    NSString *info = [injectBtnInfo yy_modelDescription];
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"participant: %@", info];
}

- (void)onClickInjectCallAllBtnNotify:(HWMUISDKCallAllBtnInfoModel *)injectBtnInfo {
    NSString *info = [injectBtnInfo yy_modelDescription];
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"onClickInjectCallAllBtnNotify: %@", info];
}

- (void)onDoubleClickParticipantListItemNotify:(HWMUISDKParticipantItemInfoModel *)participantInfo {
    NSString *info = [participantInfo yy_modelDescription];
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"onDoubleClickParticipantListItemNotify: %@", info];
}

#pragma mark - UI

- (void)setupUI {
    [self.view addSubview:self.clickItemSwitchCell];
    [self.clickItemSwitchCell mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(600);
    }];
    
    self.clickInjectParticipantItemBtn = [NSTextField hwm_fieldWithTitle:@"已开启与会者列表子项注入点击通知" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    self.clickInjectParticipantItemBtn.hidden = YES;
    [self.view addSubview:self.clickInjectParticipantItemBtn];
    [self.clickInjectParticipantItemBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.clickItemSwitchCell.mas_bottom).offset(20);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(40);
        make.width.mas_equalTo(360);
    }];
    
    self.clickInjectRecallBtn = [NSTextField hwm_fieldWithTitle:@"已开启与重新呼叫注入点击通知" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    self.clickInjectRecallBtn.hidden = YES;
    [self.view addSubview:self.clickInjectRecallBtn];
    [self.clickInjectRecallBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.clickInjectParticipantItemBtn.mas_bottom);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(40);
        make.width.mas_equalTo(360);
    }];
    
    self.clickInjectCallAllBtn = [NSTextField hwm_fieldWithTitle:@"已开启全部呼叫注入点击通知" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    self.clickInjectCallAllBtn.hidden = YES;
    [self.view addSubview:self.clickInjectCallAllBtn];
    [self.clickInjectCallAllBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.clickInjectRecallBtn.mas_bottom);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(40);
        make.width.mas_equalTo(360);
    }];
    
    self.doubleClickParticipantListItem = [NSTextField hwm_fieldWithTitle:@"已开启双击与会者项注入通知" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    self.doubleClickParticipantListItem.hidden = YES;
    [self.view addSubview:self.doubleClickParticipantListItem];
    [self.doubleClickParticipantListItem mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.clickInjectCallAllBtn.mas_bottom);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(40);
        make.width.mas_equalTo(360);
    }];
}

#pragma mark - HWMSwitchCellDelegate

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    self.clickItemSwitchState = state;
    self.clickInjectParticipantItemBtn.hidden = !state;
    self.clickInjectRecallBtn.hidden = !state;
    self.clickInjectCallAllBtn.hidden = !state;
    self.doubleClickParticipantListItem.hidden = !state;
    if (state) {
        [HWMSdk getSdkConfig].participantListHandler = self;
    } else {
        [HWMSdk getSdkConfig].participantListHandler = nil;
    }
}

#pragma mark - Lazy

- (HWMSwitchCell *)clickItemSwitchCell {
    if (!_clickItemSwitchCell) {
        _clickItemSwitchCell = [[HWMSwitchCell alloc] init];
        _clickItemSwitchCell.title = @"开启与会者列表按钮点击注入";
        _clickItemSwitchCell.delegate = self;
        _clickItemSwitchCell.state = self.clickItemSwitchState;
    }
    return _clickItemSwitchCell;
}

@end
