//
//  HWMHwndInfoListController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2021/7/23.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMHwndInfoListController.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMHwndInfoListController () <HWMBizNotificationHandler>

@property (nonatomic, strong) NSButton *hwndBtn;

@end

@implementation HWMHwndInfoListController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

- (void)viewWillAppear {
    [super viewWillAppear];
    [[HWMSdk getSdkConfig] subscribeBizNotificationHandler:self];
}

- (void)viewWillDisappear {
    [super viewWillDisappear];
    [[HWMSdk getSdkConfig] unsubscribeBizNotificationHandler:self];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.hwndBtn];
    [self.hwndBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self.view);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Event
- (void)hwndList {
    NSArray <HWMOpenHwndInfoModel *> *array = [[HWMBizSdk getBizOpenApi] getRenderWindowInfoList];
    NSMutableString *logString = [[NSMutableString alloc] initWithString:@"getRenderWindowInfoList 获取窗口句柄列表: \n"];
    for (int i = 0; i < array.count; i++) {
        HWMOpenHwndInfoModel *model = array[i];
        [logString appendFormat:@"handleType:%ld, hwndType:%ld, renderHandle:%ld", model.handleType, model.hwndType, model.renderHandle];
        if (i != array.count - 1) {
            [logString appendFormat:@"\n"];
        }
    }
    [HWMConsoleManager shareInstance].console = logString;
}

#pragma mark - Lazy
- (NSButton *)hwndBtn {
    if (!_hwndBtn) {
        _hwndBtn = [NSButton buttonWithTitle:@"获取窗口句柄列表" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(hwndList)];
        _hwndBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _hwndBtn.layer.cornerRadius = 4.0;
        _hwndBtn.layer.masksToBounds = YES;
    }
    return _hwndBtn;
}

#pragma mark - HWMBizNotificationHandler
- (void)onRenderWindowInfoList:(NSArray<HWMOpenHwndInfoModel *> *)hwndInfoList {
    NSMutableString *logString = [[NSMutableString alloc] initWithString:@"onRenderWindowInfoList 窗口句柄列表通知: \n"];
    for (int i = 0; i < hwndInfoList.count; i++) {
        HWMOpenHwndInfoModel *model = hwndInfoList[i];
        [logString appendFormat:@"handleType:%ld, hwndType:%ld, renderHandle:%ld", model.handleType, model.hwndType, model.renderHandle];
        if (i != hwndInfoList.count - 1) {
            [logString appendFormat:@"\n"];
        }
    }
    [HWMConsoleManager shareInstance].console = logString;
}

@end
