//
//  HWMWaterMarkController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/10/19.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMWaterMarkController.h"
#import "HWMTextField.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMWaterMarkController ()

@property (nonatomic, strong) HWMInputView *textInputView;
@property (nonatomic, strong) HWMInputView *colorInputView;
@property (nonatomic, strong) NSButton *setBtn;

@end

@implementation HWMWaterMarkController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI

- (void)setupUI {
    [self.view addSubview:self.textInputView];
    [self.textInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(100);
        make.centerX.mas_equalTo(0);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.colorInputView];
    [self.colorInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.textInputView.mas_bottom).offset(10);
        make.centerX.mas_equalTo(0);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.setBtn];
    [self.setBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(-100);
        make.centerX.mas_equalTo(0);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

- (void)setWaterMark {
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }
    NSColor *color = [NSColor colorWithHexString:self.colorInputView.textField.stringValue];
    if (!color) {
        color = [NSColor redColor];
    }
    NSAttributedString *arr = [[NSAttributedString alloc] initWithString:self.textInputView.textField.stringValue attributes:@{NSFontAttributeName:[NSFont systemFontOfSize:13], NSForegroundColorAttributeName:color}];
    [[HWMSdk getOpenApi] setWaterMark:arr];
}

- (HWMInputView *)textInputView {
    if (!_textInputView) {
        _textInputView = [[HWMInputView alloc] init];
        _textInputView.title = @"水印文字";
    }
    return _textInputView;
}

- (HWMInputView *)colorInputView {
    if (!_colorInputView) {
        _colorInputView = [[HWMInputView alloc] init];
        _colorInputView.title = @"水印颜色";
        _colorInputView.placeholder = @"#FFFFFFFF";
    }
    return _colorInputView;
}

- (NSButton *)setBtn {
    if (!_setBtn) {
        _setBtn = [NSButton buttonWithTitle:@"设置水印" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(setWaterMark)];
        _setBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _setBtn.layer.cornerRadius = 4.0;
        _setBtn.layer.masksToBounds = YES;
    }
    return _setBtn;
}

@end
