//
//  HWMSetConfMgrGuaranteeIpAddrsViewController.m
//  HWMUISDKNativeDemo
//
//  Created by z30074171 on 2025/2/8.
//  Copyright © 2025 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetConfMgrGuaranteeIpAddrsViewController.h"
#import "HWMTextView.h"
#import <HWMUISDK/HWMBizSdk.h>

@interface HWMSetConfMgrGuaranteeIpAddrsViewController ()<NSTextViewDelegate>
@property (nonatomic, strong) HWMTextView *textView;
@property (nonatomic, strong) NSButton *confirmBtn;
@end

@implementation HWMSetConfMgrGuaranteeIpAddrsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createView];
    // Do view setup here.
}

- (void)confirmBtnClick {
    if (!HWMSafeString(self.textView.textView.string)) {
        [HWMConsoleManager shareInstance].console = @"input conf manage config is empty";
    } else {
        NSData *data = [self.textView.textView.string dataUsingEncoding:NSUTF8StringEncoding];
        if (data) {
            NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
            NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dic options:NSJSONWritingPrettyPrinted|NSJSONWritingSortedKeys error:nil];
            NSString *strJson = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
            self.textView.textView.string = strJson;
            if (!dic) {
                [HWMConsoleManager shareInstance].console = @"param is nil,input config may be wrong";
            } else {
                NSArray<HWMSDKGuaranteedIpAddressModel *> *models = [NSArray yy_modelArrayWithClass:[HWMSDKGuaranteedIpAddressModel class] json:dic];
                __block NSMutableArray<HWMSDKGuaranteedIpAddressModel *> *params = [[NSMutableArray alloc] init];
                [models enumerateObjectsUsingBlock:^(HWMSDKGuaranteedIpAddressModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
                    if (HWMSafeString(obj.domain) && HWMSafeString(obj.guaranteedIps)) {
                        [params addObject:obj];
                    }
                }];
                if (!HWMSafeArray(params)) {
                    [HWMConsoleManager shareInstance].console = @"设置(管理面)保底ip地址列表为空，请重新设置";
                    return;
                }
                HWMSDKERR result = [[HWMBizSdk getBizOpenApi] setGlobalGuaranteedIpAddresses:params.copy];
                NSString *msg = @"设置(管理面)保底ip地址成功";
                if (result != HWMSDKSdkerrSuccess) {
                    msg = [NSString stringWithFormat:@"设置(管理面)保底ip地址失败[%ld]",result];
                }
                [HWMConsoleManager shareInstance].console = msg;
            }
        } else {
            [HWMConsoleManager shareInstance].console = @"param is nil,input config may be wrong";
        }
    }
}

- (void)createView {
    [self.view addSubview:self.textView];
    [self.textView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self).offset(60);
        make.leading.mas_equalTo(self).offset(20);
        make.trailing.mas_equalTo(self).offset(-20);
        make.height.mas_equalTo(260);
    }];
    
    [self.view addSubview:self.confirmBtn];
    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.textView.mas_bottom).offset(60);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

- (HWMTextView *)textView {
    if (!_textView) {
        _textView = [[HWMTextView alloc] initWithFrame:CGRectZero];
        _textView.placeholderString = @"[{\"domain\":\"www.abc.com\",\"guaranteedIps\":\"保底ip列表，多个地址中间用分号隔开，\n最多支持4个地址\"},{\"domain\":\"www.def.com\",\"guaranteedIps\":\"保底ip列表\"}]";
    }
    return _textView;
}
- (NSButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
        _confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmBtn.layer.cornerRadius = 4.0;
        _confirmBtn.layer.masksToBounds = YES;
    }
    return _confirmBtn;
}
@end
