//
//  HWMSetCustomTextViewController.m
//  HWMUISDKNativeDemo
//
//  Created by houxiebing on 2024/9/20.
//  Copyright © 2024 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetCustomTextViewController.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMSdk.h>

@interface HWMSetCustomTextViewController ()

@property (nonatomic, strong) HWMInputView *cnInputView;
@property (nonatomic, strong) HWMInputView *enInputView;
@property (nonatomic, strong) NSTextField *otherCode;
@property (nonatomic, strong) NSTextField *otherText;
@property (nonatomic, strong) NSPopUpButton *selectBtn;
@property (nonatomic, strong) NSButton *confirmBtn;
@property (nonatomic, assign) HWMUISDKUICustomTextScene currentScene;

@end

@implementation HWMSetCustomTextViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    _currentScene = HWMUISDKCloudRecordFinishedAlertScene;
    // Do view setup here.
    [self setupUI];
}

- (void)setupUI {
    [self.view addSubview:self.cnInputView];
    [self.view addSubview:self.enInputView];
    [self.view addSubview:self.otherCode];
    [self.view addSubview:self.otherText];
    [self.view addSubview:self.selectBtn];
    [self.view addSubview:self.confirmBtn];
    
    [self.cnInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.enInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.cnInputView.mas_bottom).offset(10);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.otherCode mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.enInputView.mas_bottom).offset(10);
        make.leading.equalTo(self.enInputView);
        make.height.mas_equalTo(30);
        make.width.mas_equalTo(50);
    }];
    
    [self.otherText mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.otherCode.mas_trailing).offset(10);
        make.trailing.equalTo(self.enInputView);
        make.top.bottom.equalTo(self.otherCode);
    }];
    
    [self.selectBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.otherCode.mas_bottom).offset(10);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.selectBtn.mas_bottom).offset(60);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
    
}


- (void)confirmBtnClick {
        
    NSMutableArray *tempArray = [NSMutableArray array];
    if (self.cnInputView.textField.stringValue.length) {
        HWMUISDKUICustomTextInfoModel *model = [[HWMUISDKUICustomTextInfoModel alloc] init];
        model.languageType = HWMUISDKLanguageZhCn;
        model.languageCode = @"cn";
        model.customText = self.cnInputView.textField.stringValue;
        [tempArray addObject:model];
    }
    if (self.enInputView.textField.stringValue.length) {
        HWMUISDKUICustomTextInfoModel *model = [[HWMUISDKUICustomTextInfoModel alloc] init];
        model.languageType = HWMUISDKLanguageEnGb;
        model.languageCode = @"en";
        model.customText = self.enInputView.textField.stringValue;
        [tempArray addObject:model];
    }
    if (self.otherCode.stringValue.length && self.otherText.stringValue.length) {
        HWMUISDKUICustomTextInfoModel *model = [[HWMUISDKUICustomTextInfoModel alloc] init];
        model.languageType = HWMUISDKLanguageCustomized;
        model.languageCode = self.otherCode.stringValue;
        model.customText = self.otherText.stringValue;
        [tempArray addObject:model];
    }
    NSString *tips = @"参数错误，必须包含中英两种模型";
    if ([self checkParam:tempArray]) {
        tips = @"配置成功，请到对应场景验证";
        HWMUISDKCustomSceneTextInfoListModel *listModel = [[HWMUISDKCustomSceneTextInfoListModel alloc] init];
        HWMUISDKCustomSceneTextInfoModel *sceneModel = [[HWMUISDKCustomSceneTextInfoModel alloc] init];
        sceneModel.sceneTextList = tempArray;
        sceneModel.scene = _currentScene;
        listModel.customSceneTextInfoList = @[sceneModel];
        [[HWMSdk getOpenApi] setCustomUITextWithCustomSceneTextInfoList:listModel];
    }
    [HWMConsoleManager shareInstance].console = tips;
}

- (BOOL)checkParam:(NSArray *)models {
    if (![models isKindOfClass:[NSArray class]] || models.count == 0) {
        return NO;
    }
    BOOL isVailed = NO;
    NSArray *languageCodeMap = @[@"cn", @"en"];
    NSMutableSet *codeSet = [NSMutableSet set];
    for (HWMUISDKUICustomTextInfoModel *model in models) {
        if ([model isKindOfClass:[HWMUISDKUICustomTextInfoModel class]] &&
            model.languageCode.length &&
            [languageCodeMap containsObject:model.languageCode] &&
            model.customText.length) {
            [codeSet addObject:model.languageCode];
            if (codeSet.count >= 2) {
                isVailed = YES;
                break;
            }
        }
    }
    return isVailed;
}

- (void)popUpButtonSelectionChanged:(NSPopUpButton *)sender {
    _currentScene = sender.indexOfSelectedItem;
}

- (HWMInputView *)cnInputView {
    if (!_cnInputView) {
        _cnInputView = [[HWMInputView alloc] init];
        _cnInputView.title = @"cn:";
        _cnInputView.placeholder = @"输入定制文案";
    }
    return _cnInputView;
}

- (HWMInputView *)enInputView {
    if (!_enInputView) {
        _enInputView = [[HWMInputView alloc] init];
        _enInputView.title = @"en:";
        _enInputView.placeholder = @"input custom text";
    }
    return _enInputView;
}

- (NSTextField *)otherCode {
    if (!_otherCode) {
        _otherCode = [[NSTextField alloc] init];
        _otherCode.placeholderString = @"other";
    }
    return _otherCode;
}

- (NSTextField *)otherText {
    if (!_otherText) {
        _otherText = [[NSTextField alloc] init];
        _otherText.placeholderString = @"other custom text";
    }
    return _otherText;
}

- (NSPopUpButton *)selectBtn {
    if (!_selectBtn) {
        _selectBtn = [[NSPopUpButton alloc] init];
        [_selectBtn addItemsWithTitles:@[@"CloudRecordFinishedAlert", @"CloudRecordFinishedInMeetingAlert"]];
        [_selectBtn setTarget:self];
        [_selectBtn setAction:@selector(popUpButtonSelectionChanged:)];
    }
    return _selectBtn;
}

- (NSButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
        _confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmBtn.layer.cornerRadius = 4.0;
        _confirmBtn.layer.masksToBounds = YES;
    }
    return _confirmBtn;
}

@end
