//
//  HWMSetLogPathController.m
//  HWMUISDKNativeDemo
//
//  Created by 204053 on 2023/7/24.
//  Copyright © 2023 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetLogPathController.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMUISDK.h>
#import <HWMUISDK/HWMUISDKConfigService.h>
#import "SDKEnvConfig.h"

@interface HWMSetLogPathController ()

/// 日志路径
@property (nonatomic, strong) HWMInputView *logPathInputView;

@property (nonatomic, strong) NSButton *confirmBtn;
@property (nonatomic, strong) NSButton *openBtn;
@property (nonatomic, strong) HWMInputView *logPathDisplayView;

@end

@implementation HWMSetLogPathController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - Event

- (void)confirmBtnClick {
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"%s",__func__];
    NSString *logPath = self.logPathInputView.textField.stringValue;
    if (logPath.length == 0) {
        [HWMConsoleManager shareInstance].console = @"please enter log path.";
        return;
    }

    logPath = [[SDKEnvConfig sharedInstance].sandBoxDataPath stringByAppendingPathComponent:logPath];

    [HWMSdk setLogPath:logPath];
    [SDKEnvConfig sharedInstance].logPath = logPath;
    self.logPathDisplayView.textField.stringValue = logPath;
}

- (void)openLogBtnClick {
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"%s",__func__];
    [[NSWorkspace sharedWorkspace] openURL:[NSURL fileURLWithPath:[SDKEnvConfig sharedInstance].sandBoxDataPath]];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.logPathInputView];
    [self.view addSubview:self.logPathDisplayView];
    [self.view addSubview:self.confirmBtn];
    [self.view addSubview:self.openBtn];

    [self.logPathInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(400);
    }];
    
    [self.logPathDisplayView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.logPathInputView.mas_bottom).offset(20);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(400);
    }];

    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.logPathDisplayView.mas_bottom).offset(60);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];

    [self.openBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.confirmBtn.mas_bottom).offset(30);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Lazy
- (HWMInputView *)logPathInputView {
    if (!_logPathInputView) {
        _logPathInputView = [[HWMInputView alloc] init];
        _logPathInputView.title = @"设置日志路径";
        _logPathInputView.placeholder = @"仅填写相对于沙盒的路径部分,比如填日期:20230724";
    }
    return _logPathInputView;
}

- (NSButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
        _confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmBtn.layer.cornerRadius = 4.0;
        _confirmBtn.layer.masksToBounds = YES;
    }
    return _confirmBtn;
}

- (NSButton *)openBtn {
    if (!_openBtn) {
        _openBtn = [NSButton buttonWithTitle:@"打开日志目录" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(openLogBtnClick)];
        _openBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _openBtn.layer.cornerRadius = 4.0;
        _openBtn.layer.masksToBounds = YES;
    }
    return _openBtn;
}

- (HWMInputView *)logPathDisplayView {
    if (!_logPathDisplayView) {
        _logPathDisplayView = [[HWMInputView alloc] init];
        _logPathDisplayView.title = @"当前日志路径";
        if ([HWMSdk getSdkConfig].logPath.length > 0) {
            _logPathDisplayView.textField.stringValue = [HWMSdk getSdkConfig].logPath;
        } else {
            _logPathDisplayView.textField.stringValue = [[SDKEnvConfig sharedInstance].sandBoxDataPath stringByAppendingFormat:@"/Logs"];;
        }
    }
    return _logPathDisplayView;
}

@end
