//
//  HWMVirtualBackgroundConfigController.m
//  HWMUISDKNativeDemo
//
//  Created by lining on 2022/5/12.
//  Copyright © 2022 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMVirtualBackgroundConfigController.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMVirtualBackgroundConfigController ()

/// 图片数量
@property (nonatomic, strong) HWMInputView *imageCountInputView;
@property (nonatomic, strong) NSButton *replaceButton;
@property (nonatomic, strong) NSButton *appendButton;
@property (nonatomic, strong) NSButton *confirmButton;
@property (nonatomic, assign) HWMSettingVBDefaultImageMode mode;

@end

@implementation HWMVirtualBackgroundConfigController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.mode = HWMSettingVBDefaultImageModeAppend;
    [self setupUI];
}

- (void)setupUI {
    [self.view addSubview:self.imageCountInputView];
    [self.view addSubview:self.appendButton];
    [self.view addSubview:self.replaceButton];
    [self.view addSubview:self.confirmButton];
    
    [self.imageCountInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(120);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(400);
    }];
    
    [self.appendButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.imageCountInputView.mas_bottom).offset(20);
        make.leading.mas_equalTo(200);
    }];
    
    [self.replaceButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.appendButton);
        make.trailing.mas_equalTo(-200);
    }];

    [self.confirmButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-100);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

- (void)buttonClicked:(NSButton *)btn {
    self.mode = btn.tag;
}

- (void)confirmButtonClick{
    NSString *imageCountStr = self.imageCountInputView.textField.stringValue;
    NSInteger count = [imageCountStr integerValue];
    if (count <= 0) {
        [HWMConsoleManager shareInstance].console = @"set virtual background default image fail, count is <= 0.";
        return;
    }
    NSString *path = [[NSBundle bundleForClass:[self class]] resourcePath];
    NSString *imageDir = [path stringByAppendingPathComponent:@"vb"];
    NSArray *imageNameList = [[NSFileManager defaultManager] contentsOfDirectoryAtPath:imageDir error:NULL];
    imageNameList = [imageNameList sortedArrayUsingComparator:^NSComparisonResult(NSString * _Nonnull obj1, NSString * _Nonnull obj2) {
        return [obj1 compare:obj2];
    }];
    count = MIN(imageNameList.count,count);
    NSMutableArray *images = [NSMutableArray arrayWithCapacity:count];
    for (int i = 0; i < count; i++) {
        NSString *imagePath = [imageDir stringByAppendingPathComponent:imageNameList[i]];
        HWMVirtualBackgroundImageModel *model = [HWMVirtualBackgroundImageModel new];
        model.imagePath = imagePath;
        [images addObject:model];
    }
    HWMVirtualBackgroundParam *param = [HWMVirtualBackgroundParam new];
    param.mode = self.mode;
    param.imageModels = images;
    [[HWMSdk getOpenApi] setVirtualBackgroundDefaultImages:param];
    [HWMConsoleManager shareInstance].console = @"set virtual background default image success.";
}

- (HWMInputView *)imageCountInputView {
    if (!_imageCountInputView) {
        _imageCountInputView = [[HWMInputView alloc] init];
        _imageCountInputView.title = @"虚拟背景默认图片数量:";
        _imageCountInputView.placeholder = @"请输入虚拟背景默认图片数量";
    }
    return _imageCountInputView;
}

- (NSButton *)replaceButton {
    if (!_replaceButton) {
        _replaceButton = [[NSButton alloc] init];
        _replaceButton.bordered = NO;
        _replaceButton.font = [NSFont systemFontOfSize:12];
        _replaceButton.bezelStyle = NSBezelStyleRegularSquare;
        _replaceButton.state = NSControlStateValueOff;
        [_replaceButton setButtonType:NSButtonTypeRadio];
        [_replaceButton setTitle:@"替换"];
        _replaceButton.target = self;
        _replaceButton.action = @selector(buttonClicked:);
        _replaceButton.tag = HWMSettingVBDefaultImageModeReplaceAll;
    }
    return _replaceButton;
}

- (NSButton *)appendButton {
    if (!_appendButton) {
        _appendButton = [[NSButton alloc] init];
        _appendButton.bordered = NO;
        _appendButton.font = [NSFont systemFontOfSize:12];
        _appendButton.bezelStyle = NSBezelStyleRegularSquare;
        _appendButton.state = NSControlStateValueOn;
        [_appendButton setButtonType:NSButtonTypeRadio];
        [_appendButton setTitle:@"追加"];
        _appendButton.target = self;
        _appendButton.action = @selector(buttonClicked:);
        _appendButton.tag = HWMSettingVBDefaultImageModeAppend;
    }
    return _appendButton;
}

- (NSButton *)confirmButton {
    if (!_confirmButton) {
        _confirmButton = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmButtonClick)];
        _confirmButton.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmButton.layer.cornerRadius = 4.0;
        _confirmButton.layer.masksToBounds = YES;
    }
    return _confirmButton;
}

@end
