//
//  HWMSetHeaderViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/6.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetHeaderViewController.h"
#import <HWMUISDK/HWMUISDK.h>
@interface HWMSetHeaderViewController ()<HWMHeadPortraitApiHandler>

/// 按钮
@property (nonatomic, strong) NSButton *chooseBtn;
/// 上传头像
@property (nonatomic, strong) NSButton *uploadBtn;
/// 注入头像
@property (nonatomic, strong) NSButton *registerBtn;

@end

@implementation HWMSetHeaderViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

- (void)viewWillAppear {
    [super viewWillAppear];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.uploadBtn];
    [self.view addSubview:self.registerBtn];
    [self.view addSubview:self.chooseBtn];

    [self.uploadBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.view).offset(200);
        make.top.equalTo(self.view).offset(100);
    }];

    [self.registerBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self.view).offset(-200);
        make.top.equalTo(self.uploadBtn.mas_top);
    }];

    [self.chooseBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-100);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Event
- (void)chooseBtnClick {
    NSOpenPanel *panel = [[NSOpenPanel alloc] init];
    panel.canChooseFiles = YES;
    panel.canChooseDirectories = NO;
    panel.allowedFileTypes = @[@"png", @"jpg", @"jpeg", @"bmp"];
    [panel beginSheetModalForWindow:self.view.window completionHandler:^(NSModalResponse result) {
        if (result == 1) {
            NSString *path = [panel.URL path];

            [[HWMBizSdk getBizOpenApi] uploadSelfAvatar:path success:^{
                [HWMConsoleManager shareInstance].console = @"set succeeded";
            } fail:^(NSError *_Nonnull error) {
                [HWMConsoleManager shareInstance].error = error;
            }];
        }
    }];
}

- (void)queryContactAvatarWithContactInfo:(HWMUISDKContactInfoModel *)contactInfo
                          completionBlock:(void (^)(NSError *_Nullable error, NSString *_Nullable headImagePath))completionBlock {
    
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"queryContactAvatar:%@", [contactInfo yy_modelDescription]];
    if (completionBlock) {
        /// 将图片路径返回给SDK
        NSInteger index = arc4random() % 3;
        NSString *path = [[NSBundle bundleForClass:[self class]] pathForResource:[NSString stringWithFormat:@"head_icon_%lu", index] ofType:@"png"];
        
        completionBlock(nil, path);
    }
}

- (void)setHeaderTypeChanged:(NSButton *)sender {
    if (sender.tag) {
        [HWMSdk getSdkConfig].headPortraitApiHandler = self;
        self.chooseBtn.hidden = YES;
    } else {
        [HWMSdk getSdkConfig].headPortraitApiHandler = nil;
        self.chooseBtn.hidden = NO;
    }
}

#pragma mark - Lazy
- (NSButton *)chooseBtn {
    if (!_chooseBtn) {
        _chooseBtn = [NSButton buttonWithTitle:@"设置头像" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(chooseBtnClick)];
        _chooseBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _chooseBtn.layer.cornerRadius = 4.0;
        _chooseBtn.layer.masksToBounds = YES;
    }
    return _chooseBtn;
}

- (NSButton *)uploadBtn {
    if (!_uploadBtn) {
        _uploadBtn = [[NSButton alloc] init];
        _uploadBtn.bordered = NO;
        _uploadBtn.font = [NSFont systemFontOfSize:12];
        _uploadBtn.bezelStyle = NSBezelStyleRegularSquare;
        _uploadBtn.state = NSControlStateValueOn;
        [_uploadBtn setButtonType:NSButtonTypeRadio];
        [_uploadBtn setTitle:@"上传头像"];
        _uploadBtn.target = self;
        _uploadBtn.action = @selector(setHeaderTypeChanged:);
        _uploadBtn.tag = 0;
    }
    return _uploadBtn;
}

- (NSButton *)registerBtn {
    if (!_registerBtn) {
        _registerBtn = [[NSButton alloc] init];
        _registerBtn.bordered = NO;
        _registerBtn.font = [NSFont systemFontOfSize:12];
        [_registerBtn setBezelStyle:NSBezelStyleRegularSquare];
        [_registerBtn setButtonType:NSButtonTypeRadio];
        [_registerBtn setState:NSControlStateValueOff];
        [_registerBtn setTitle:@"注入头像"];
        _registerBtn.target = self;
        _registerBtn.action = @selector(setHeaderTypeChanged:);
        _registerBtn.tag = 1;
    }
    return _registerBtn;
}

@end
