//
//  HWMAppKeyManager.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/16.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMAppKeyManager.h"

@implementation HWMAppKeyManager

+ (instancetype)shareInstance {
    static dispatch_once_t onceToken;
    static HWMAppKeyManager *manager = nil;
    dispatch_once(&onceToken, ^{
        manager = [[HWMAppKeyManager alloc] init];
    });
    return manager;
}

- (NSString *)appId {
    if (_appId.length == 0) {
        // 请将AppID替换为您已申请到的AppID
        NSString *plistPath = [[NSBundle bundleForClass:[self class]] pathForResource:@"HWMUISDKDemoConfig" ofType:@"plist"];
        NSMutableDictionary *plistDic = [[NSMutableDictionary alloc] initWithContentsOfFile:plistPath];
        _appId = [plistDic valueForKey:@"AppId"];

    }
    return _appId;
}

@end
