//
//  HWMBizNotificationHandler.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/14.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"
#import "HWMAttendeeInfo.h"
#import "HWMConfListItemInfo.h"
#import "HWMConfStateInfo.h"
#import "HWMOpenHwndInfoModel.h"
#import "HWMAudioFrameDataModel.h"
#import "HWMUISDKShareStateInfoModel.h"
#import "HWMUISDKDeviceStateInfoModel.h"
#import "HWMUISDKSpeakerListModel.h"
#import "HWMUISDKVideoStreamTypeInfoModel.h"
#import "HWMUISDKConfEndInfoModel.h"
#import "HWMUISDKLocalRecordStateInfoModel.h"
#import "HWMUISDKOperateExternalInviteeInfoModel.h"
#import "HWMUISDKInterruptInfoModel.h"
#import "HWMSDKRealTimeSubtitleModel.h"
#import "HWMSDKSubtitleRecordInfoModel.h"

NS_ASSUME_NONNULL_BEGIN

@protocol HWMBizNotificationHandler <NSObject>

@optional
/// 个人角色变化通知
/// @param confRole 角色
- (void)onSelfRoleChanged:(HWMConfRoleType)confRole;

/// 会议状态变更通知
/// @param status 会议状态
- (void)onConfStatusChanged:(HWMConfStatus)status;

/// 会议列表变化通知
/// @param confList 全量会议列表
- (void)onReceiveConfList:(NSArray<HWMConfListItemInfo *> *)confList;

/// 会中会议状态信息改变
/// @param confInfo 会议信息
- (void)onConfInfoNotify:(HWMConfStateInfo *)confInfo DEPRECATED_MSG_ATTRIBUTE("可通过onMeetingInfoChanged实现，该接口已废弃");

/// 会议基本信息更新通知
/// @param meetingInfo 会议基本信息
- (void)onMeetingInfoChanged:(HWMSDKMeetingInfoModel *)meetingInfo;

/// 会议结束通知
/// @param confEndInfo 会议结束信息
- (void)onConfEndedNotify:(HWMUISDKConfEndInfoModel *)confEndInfo;

/// 窗口句柄信息通知
/// @param hwndInfoList 窗口句柄列表
- (void)onRenderWindowInfoList:(NSArray<HWMOpenHwndInfoModel *> *)hwndInfoList;

/// 收到音频流
- (void)onAudioFrameDataNotify:(HWMAudioFrameDataModel *)pFrame;

/// 自己共享状态变化
/// @param shareStateInfo 正在共享的信息
- (void)onShareStateChanged:(HWMUISDKShareStateInfoModel *)shareStateInfo;

/// 弱网提示通知
- (void)onPoorNetworkQualityInfoNotify:(HWMSDKPoorNetWorkQualityInfoModel *)poorNetWorkInfo;

/// 会中标注状态通知
- (void)onAnnotationStatusChanged:(BOOL)isOpenAnnotation;

/// 会中音视频设备控制状态变化通知
- (void)onAVDeviceCtrlStateChanged:(HWMUISDKDeviceStateInfoModel *)stateInfo;

/// 发言人变更的通知
- (void)onSpeakerListChanged:(HWMUISDKSpeakerListModel *)speakerListInfo;

/// 视频流类型的变化通知
- (void)onVideoStreamTypeChanged:(HWMUISDKVideoStreamTypeInfoModel *)videoStreamTypeInfo;

/// 视频与会者列表变化通知
- (void)onVideoAttendeeListChanged;

/// 添加与会者结果通知
- (void)onAddAttendeeNotify:(HWMSDKAddAttendeeResultListModel *)resultList;

/// 本地录制状态通知
- (void)onSelfLocalRecordStateNotify:(HWMUISDKLocalRecordStateInfoModel *)localRecordStateInfo;

/// 等候室列表更新通知
- (void)onWaitingListChanged:(NSArray<HWMAttendeeInfo *> *)waitingInfoList;

/// 邀请或挂断外部受邀者
- (void)onOperateExternalAttendeeNotify:(HWMUISDKOperateExternalInviteeInfoModel *)externalInviteeInfo;

/// 批量呼叫外部与会者
- (void)onCallAllExternalAttendeesNotify:(NSArray<HWMUISDKExternalInviteeModel *> *)externalAttendees;

/// 与会者列表更新通知
- (void)onAttendeeListChanged:(NSArray<HWMAttendeeInfo *> *)attendeeList;

/// 字幕状态变更通知
- (void)onSubtitleStateChanged:(BOOL)isOpen;

/// 等候室状态变更通知
- (void)onWaitingRoomStateChanged:(BOOL)isOpen;

/// 字幕消息实时通知
- (void)onRealTimeSubtitleInfoNotify:(HWMSDKRealTimeSubtitleModel *)realTimeSubtitle;

/// 字幕记录消息通知
- (void)onSubtitleRecordNotify:(HWMSDKSubtitleRecordInfoModel *)subtitleInfo;

/// 本地录制操作中断通知
- (void)onStartLocalRecordOperationInterruptNotify:(HWMUISDKInterruptInfoModel *)info;

@end

NS_ASSUME_NONNULL_END
