//
//  HWMCreateConfResult.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/9.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMCreateConfResult : NSObject
/// 会议主题
@property (nonatomic, copy) NSString *confSubject;

/// 会议id
@property (nonatomic, copy) NSString *confId;

/// 个人会议id
@property (nonatomic, copy) NSString *vmrConferenceId;

/// 来宾密码
@property (nonatomic, copy) NSString *generalPwd;

/// 会议接入号
@property (nonatomic, copy) NSString *accessNumber;

/// 主持人密码
@property (nonatomic, copy) NSString *confChairPwd;

/// 会议来宾链接
@property (nonatomic, copy) NSString *confUri;

/// 会议开始时间
@property (nonatomic, assign) NSTimeInterval startTime DEPRECATED_MSG_ATTRIBUTE("Use 'startTimeStamp' instead");

/// 会议结束时间
@property (nonatomic, assign) NSTimeInterval endTime DEPRECATED_MSG_ATTRIBUTE("Use 'endTimeStamp' instead");

/// 会议开始时间戳，精度秒
@property (nonatomic, assign) NSInteger startTimeStamp;

/// 会议结束时间戳，精度秒
@property (nonatomic, assign) NSInteger endTimeStamp;

/// 预订者名字
@property (nonatomic, copy) NSString *confScheduledName; 

/// 会议角色
@property (nonatomic, assign) HWMConfRoleType confRole;

/// 是否是视频会议
@property (nonatomic, assign) BOOL videoConf;

/// 是否立即会议
@property (nonatomic, assign) BOOL isP2PConf;

/// 会议最大与会人数
@property (nonatomic, assign) NSUInteger concurrentParticipants;

@end

NS_ASSUME_NONNULL_END
