//
//  HWMNotifyHandler.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/15.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMCorpConfigInfo.h"
#import "HWMLoginStatusInfo.h"
#import "HWMConfIncomingInfo.h"
#import "HWMP2PConfRecordInfoModel.h"

NS_ASSUME_NONNULL_BEGIN

@protocol HWMNotifyHandler <NSObject>
@optional

/// 账号被踢，收到该通知表示账号已经在其他设备登录，如果需要继续操作，需要重新调用登录接口
/// 可选，建议接入方实现，在被踢时给用户合理提示
- (void)onKickedOut;

/// 登录的企业配置信息下发
/// 里面有是否有权限发送短信、是否有权限进行会议的录播、以及外呼手机号码权限
/// @param corpConfig 配置信息
- (void)onCorpConfigNotify:(HWMCorpConfigInfo *)corpConfig;

/// 客户企业信息变更通知
/// @param type 企业信息变更类型
- (void)onUserCorpInfoNotify:(HWMUserCorpInfoNotifyType)type;

/// 收到全局的登录相关错误消息
/// @param error 错误信息
- (void)onLoginError:(NSError *)error;

/// 收到全局的会议来电
/// @param confIncomingInfo 会议来电信息
- (void)onConfIncoming:(HWMConfIncomingInfo *)confIncomingInfo;

/// 立即会议通话记录
- (void)onP2PConfRecord:(HWMP2PConfRecordInfoModel *)recordInfo;

/// 共享vmr变更
- (void)onShareVmrInfoNotify:(HWMSDKShareVmrInfoModel *)shareVmrInfo;

/// 登录状态变化通知
- (void)onLoginStateChangeNotify:(HWMLoginState)loginState;

@end

NS_ASSUME_NONNULL_END
