//
//  HWMOrderConfParam.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/13.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMAttendeeInfo.h"
#import "HWMSdkDefine.h"
#import "HWMSDKCommonDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMOrderConfParam : NSObject
/// （必填）会议主题
@property (nonatomic, copy) NSString *confSubject;

/// （废弃）会议开始时间 UTC时间戳，精度秒
@property (nonatomic, assign) NSTimeInterval startTime DEPRECATED_MSG_ATTRIBUTE("Use 'startTimeStamp' instead");

/// （必填）会议开始时间时间戳，精度秒
@property (nonatomic, assign) NSTimeInterval startTimeStamp;

/// （必填）会议持续时长，单位分钟
@property (nonatomic, assign) NSUInteger duration;

// 时区 见华为云开发者官网说明 https://support.huaweicloud.com/api-meeting/meeting_21_0110.html
// 默认值当前时区  选填
@property (nonatomic, assign) NSUInteger timeZone;

/// 是否自动录制会议
@property (nonatomic, assign) BOOL isAutoRecord;

/// 是否打开会议录制
@property (nonatomic, assign) BOOL isRecordOn;

/// 是否开启直播
@property (nonatomic, assign) BOOL isLiveOn;

/// （选填） 若预约的为个人会议或者云会议室时传入 若预约的为随机会议 不传递
@property (nonatomic, copy) NSString *vmrId;

/// 允许入会范围限制
@property (nonatomic, assign) HWMJoinConfRestrictionType callInRestrictionType;

/// 与会者信息
@property (nonatomic, strong) NSArray<HWMAttendeeInfo *> *attendee;

/// 发送短信通知开关，可选参数，企业配置里面需要开启，否则不生效
/// 企业是否有短信权限见onCorpConfigNotify通知
@property (nonatomic, assign) BOOL isSmsOn;

/// 发送邮件通知开发，可选参数，企业配置里面需要开启，否则不生效
@property (nonatomic, assign) BOOL isMailOn;

/// 发送邮件日历开关
@property (nonatomic, assign) BOOL isEmailCalenderOn;

/// 编辑会议时使用，预约会议时不需要传递
@property (nonatomic, copy) NSString *confId;

/// (选填) 会议是否无密码，默认为否，有密码。创建个人VMR会议时此选项无效
@property (nonatomic, assign) BOOL noPassword;

/// (选填) 指定来宾入会密码，默认不填，随机生成密码。创建个人VMR会议时此选项无效，使用个人VMR会议室密码
@property (nonatomic, copy) NSString *guestPwd;

/// (选填) 是否指定创建视频会议，默认视频
@property (nonatomic, assign) BOOL isVideo;

/// (选填) 云会议室的会议ID类型，默认固定类型，编辑会议时不可修改
@property (nonatomic, assign) HWMVmrConfIdType vmrConfIdType;

/// (选填) 是否允许来宾提前启动会议 默认为YES (即允许来宾提前入会)
@property (nonatomic, assign) BOOL allowGuestStartConf;

/// 允许来宾提前入会时间范围(单位：分钟)
/// (选填) 预约随机会议id会议可选
/// 0-随时，n-提前n分钟启动会议 n可取值:0,5,10,15,30 默认为0(即可随时入会)
@property (nonatomic, assign) NSInteger allowGuestStartConfTime;

/// (选填)  是否开启等候室。需开通等候室功能后该设置才生效。
@property (nonatomic, assign) BOOL isOpenWaitingRoom;

/// (选填)  自定义信息
@property (nonatomic, copy) NSString *customInfo;

/// (选填）会议最大与会人数，默认0
@property (nonatomic, assign) NSUInteger concurrentParticipants;

/// 会议资源类型
@property (nonatomic, assign) HWMConfResType confResType;

/// 个人客户端入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType autoMuteMode;

/// 会议室设备入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType hardTerminalAutoMuteMode;

/// 是否支持水印 
@property (nonatomic, assign) BOOL supportWatermark;

/// 录制时，智能会议纪要的默认状态，仅支持会议纪要时生效
@property (nonatomic, assign) HWMSummaryState defaultSummaryState;

/// 是否免审核自动发布纪要
@property (nonatomic, assign) BOOL autoPublishSummary;

/// 与会者列表是否排除自己
@property (nonatomic, assign) BOOL attendeesExcludeSelf;

@end

NS_ASSUME_NONNULL_END
