/*
 Copyright (c) 2011, Tony Million.
 All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 
 1. Redistributions of source code must retain the above copyright notice, this
 list of conditions and the following disclaimer.
 
 2. Redistributions in binary form must reproduce the above copyright notice,
 this list of conditions and the following disclaimer in the documentation
 and/or other materials provided with the distribution.
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGE.
 */

#import <Foundation/Foundation.h>
#import <SystemConfiguration/SystemConfiguration.h>

//! Project version number for MacOSReachability.
FOUNDATION_EXPORT double HWMSDKReachabilityVersionNumber;

//! Project version string for MacOSReachability.
FOUNDATION_EXPORT const unsigned char HWMSDKReachabilityVersionString[];

/**
 * Create NS_ENUM macro if it does not exist on the targeted version of iOS or OS X.
 *
 * @see http://nshipster.com/ns_enum-ns_options/
 **/
#ifndef NS_ENUM
#define NS_ENUM(_type, _name) enum _name : _type _name; enum _name : _type
#endif

extern NSString *const kHWMSDKReachabilityChangedNotification;

typedef NS_ENUM(NSInteger, HWMSDKNetworkStatus) {
    // Apple HWMSDKNetworkStatus Compatible Names.
    NotReachable = 0,
    ReachableViaWiFi = 2,
    ReachableViaWWAN = 1
};

typedef NS_ENUM(NSInteger, HWMSDKWakeupConferenceType) {
    HWMSDKWakeupConferenceTypeNone = 0,   /// 不需要唤醒
    HWMSDKWakeupConferenceTypeLink = 1,   /// 连接会议
};

@class HWMSDKReachability;

typedef void (^NetworkReachable)(HWMSDKReachability * reachability);
typedef void (^NetworkUnreachable)(HWMSDKReachability * reachability);
typedef void (^NetworkReachability)(HWMSDKReachability * reachability, SCNetworkConnectionFlags flags);


@interface HWMSDKReachability : NSObject

@property (nonatomic, assign) BOOL reachableOnWWAN;

+ (instancetype)shareInstance;
- (void)setReachableHostname:(NSString *)hostname;
- (NSString *)getReachableHostname;
- (void)setReachableRemoteAddress:(void *)hostAddress;
- (void)setReachableURL:(NSURL *)url;

- (void)insertReachableBlack:(NetworkReachable)reachable;
- (void)insertUnReachableBlack:(NetworkUnreachable)unReachable;
- (void)insertReachablilityBlack:(NetworkReachability)reachability;

- (void)removeReachableBlack:(NetworkReachable)reachable;
- (void)removeUnReachableBlack:(NetworkUnreachable)unReachable;
- (void)removeReachablilityBlack:(NetworkReachability)reachability;

- (void)removeAllBlack;

-(BOOL)startNotifier;
-(void)stopNotifier;

-(BOOL)isReachable;
-(BOOL)isReachableViaWWAN;
-(BOOL)isReachableViaWiFi;

// WWAN may be available, but not active until a connection has been established.
// WiFi may require a connection for VPN on Demand.
-(BOOL)isConnectionRequired; // Identical DDG variant.
-(BOOL)connectionRequired; // Apple's routine.
// Dynamic, on demand connection?
-(BOOL)isConnectionOnDemand;
// Is user intervention required?
-(BOOL)isInterventionRequired;

-(HWMSDKNetworkStatus)currentReachabilityStatus;
-(SCNetworkReachabilityFlags)reachabilityFlags;
-(NSString*)currentReachabilityString;
-(NSString*)currentReachabilityFlags;

//查找本地设备和远端通信使用的ip地址，第一次请求可能存在耗时
- (NSString *) localIpAddress;
@end
