//
//  HWMUISDKPrivateMeetingService.h
//  HWMSDKSDK
//
//  Automatically generated file. DO NOT MODIFY!!!
//

#import <Foundation/Foundation.h>
#import "HWMUISDKCommonDefine.h"
#import "HWMUISDKAllModelIndex.h"

#import "HWMUISDKPrivateMeetingService.h"

NS_ASSUME_NONNULL_BEGIN

typedef void(^HWMSDKStartCtdConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKGetSSOAuthorizeUrlHandler) (NSError * _Nullable error, NSString * ssoAuthorizeUrl);

typedef void(^HWMSDKGetProxyHandler) (NSError * _Nullable error, HWMUISDKProxyInfoModel * proxyInfo);

typedef void(^HWMSDKJoinConfByLinkHandler) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByTokenHandler) (NSError * _Nullable error, HWMUISDKLoginByTokenResultModel * loginByTokenResult);

typedef void(^HWMSDKLoginByThirdUserInfoHandler) (NSError * _Nullable error);

typedef void(^HWMSDKSetCorpDepartmentInfoHandler) (NSError * _Nullable error);

typedef void(^HWMSDKEndProjectionHandler) (NSError * _Nullable error);

typedef void(^HWMSDKSwitchProjectionToConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKQueryVersionInfoHandler) (NSError * _Nullable error, HWMUISDKQueryVersionInfoResultModel * queryResultInfo);

typedef void(^HWMSDKUpdateExternalInviteesListHandler) (NSError * _Nullable error);

typedef void(^HWMSDKStartPlayAudioFileHandler) (NSError * _Nullable error);

typedef void(^HWMSDKSetOtherNumberHandler) (NSError * _Nullable error);

typedef void(^HWMSDKSetDeployInfoHandler) (NSError * _Nullable error);

typedef void(^HWMSDKSetInnerHttpProxyInfoHandler) (NSError * _Nullable error);

typedef void(^HWMSDKSetMeetingCustomInfoHandler) (NSError * _Nullable error);


@protocol HWMUISDKPrivateMeetingNotify <NSObject>

@optional
/// [en] Notify of pair code refresh. [cn] 配对码信息刷新通知
- (void)onRefreshPairCode:(HWMUISDKPairCodeInfoModel *)info;
/// [en] Notify of token refresh. [cn] token刷新通知
- (void)onLoginTokenRefreshNotify:(HWMUISDKPrivateLoginStateInfoModel *)info;
/// [en] Notify of query corp department info [cn] 批量查询部门信息通知
- (void)onQueryCorpDepartmentInfo:(HWMUISDKQueryCorpDepartmentInfoParamListModel *)queryDepartInfoParamList;
/// [en]Notify of conf event info [cn]会中事件信息上报通知
- (void)onConfEventInfoNotify:(NSString *)eventInfo;
/// [en] Notify of scan join conf result [cn] 扫码入会通知
- (void)onScanInfoForJoinConfNotify:(HWMUISDKScanJoinConfResultModel *)scanJoinConfResult;
/// [en] meeting config notify [cn] 跟随高级参数返回的会议配置项
- (void)onAppCfgChanged:(NSString *)meetingConfig;
/// [en] Notify of pair verify code. [cn] 配对验证码通知
- (void)onPairVerifyCodeNotify:(HWMUISDKPairVerifyCodeInfoModel *)pairVerifyCodeInfo;
/// [en] Notify of pair link list. [cn] 配对链路列表通知
- (void)onPairLinkListNotify:(HWMUISDKPairLinkListInfoModel *)pairLinkListInfo;
/// [en] Notify of pair link suceess. [cn] 配对链路成功通知
- (void)onPairLinkSuccessNotify;
/// [en] Notify of msg from pair link. [cn] 配对链路中消息上报
- (void)onRecvMsgFromPairLinkNotify:(NSString *)msgInfo;
/// [en] Notice of abnormal leave meeting [cn] 异常断开的会议通知
- (void)onAbnormalLeaveMeetingNotify:(HWMUISDKAbnormalLeaveMeetingInfoModel *)abnormalLeaveMeetingInfo;
/// [en] Notify external invitee of invite、hangup、 recall or call other [cn] 外部与会者的邀请、挂断、重呼、呼叫其他号码等操作的通知
- (void)onOperateExternalAttendeeNotify:(HWMUISDKOperateExternalInviteeInfoModel *)operateInfo;
/// [en] Notify external invitee of invite all not in conf [cn] 外部与会者的批量邀请操作的通知
- (void)onCallAllExternalAttendeesNotify:(HWMUISDKCallAllExternalAttendeesInfoModel *)operateInfo;
/// [en] Notify of query other number info [cn] 请求其他号码
- (void)onQueryOtherNumberNotify:(HWMUISDKQueryOtherNumberInfoModel *)queryOtherNumberInfo;

@end

@interface HWMUISDKPrivateMeetingService : NSObject

+ (instancetype)shareInstance;
+ (void)releaseInstance;
- (void)addPrivateMeetingNotifyCallback:(id<HWMUISDKPrivateMeetingNotify>)callback;
- (void)removePrivateMeetingNotifyCallback:(id<HWMUISDKPrivateMeetingNotify>)callback;
/// [en] This interface is used to book ctd conf. [cn] 预约ctd会议(新内部接口)
- (void)startCtdConfWithInfo:(HWMUISDKCtdConfInfoModel *)info callback:(HWMSDKStartCtdConfHandler)callback;

/// [en] This interface is used to refresh meeting token. [cn] 刷新usg会议token
- (HWMUISDKSDKERR)refreshMeetingToken;

/// [en] This interface is used to verify CA. [cn] 证明书校验开关
- (HWMUISDKSDKERR)enableCAVerification:(BOOL)isVerify;

/// [en] This method is used to get SSO authorise url. [cn] 根据企业域名获取鉴权中心Url
- (void)getSSOAuthorizeUrlWithDomain:(NSString *)domain callback:(HWMSDKGetSSOAuthorizeUrlHandler)callback;

/// [en] This interface is used to get proxy info. [cn] 获取代理信息
- (void)getProxyWithCallback:(HWMSDKGetProxyHandler)callback;

/// [en] This interface is used to login sdk by account and token. [cn] token登录
- (void)loginByTokenWithInfo:(HWMUISDKAccountAndTokenAuthInfoModel *)info callback:(HWMSDKLoginByTokenHandler)callback;

/// [en] This interface is used to login by third user info. [cn] 通过第三方用户信息登录
- (void)loginWithInfo:(HWMUISDKThirdUserInfoModel *)info callback:(HWMSDKLoginByThirdUserInfoHandler)callback;

/// [en] This interface is used to join conf by link. [cn] 通过链接入会
- (void)joinConfByLinkWithInfo:(HWMUISDKJoinConfByLinkInfoModel *)info callback:(HWMSDKJoinConfByLinkHandler)callback;

/// [en]This interface is used to get whether call is enable. [cn]呼叫是否登录上
- (BOOL)getCallIsEnable;

/// [en]This interface is used to get whether rtc conf can be created. [cn]是否可以创建RTC会议
- (BOOL)getRtcIsEnable;

/// [en] Set Corp Department Info. [cn] 批量设置用户部门信息
- (void)setCorpDepartmentInfoWithCorpDepartInfoList:(HWMUISDKSetCorpDepartmentInfoListModel *)corpDepartInfoList callback:(HWMSDKSetCorpDepartmentInfoHandler)callback;

/// [en]Set indicates enable sparkrtc flag [cn]设置是否支持sparkrtc会议
- (HWMUISDKSDKERR)setEnableRtc:(BOOL)enableRtc;

/// [en] This interface is used to apply json config. [cn] 获取json配置
- (HWMUISDKSDKERR)applyObsJsonConfigFromDB;

/// [en] This interface is used to break pair link. [cn] 断开配对链路
- (void)breakPairLinkWithInfo:(HWMUISDKPairLinkInfoModel *)info;

/// [en] This interface is modify pair link mode. [cn] 修改配对链路模式,临时/固定
- (void)modifyPairLinkModeWithInfo:(HWMUISDKPairLinkInfoModel *)info;

/// [en] This interface is send custom msg to pair link. [cn] 发送自定义消息到配对链路
- (void)sendCustomMsgToPairLinkWithCustomMsg:(NSString *)customMsg;

/// [en] This interface is stop refresh pair verify code [cn] 停止刷新配对验证码
- (HWMUISDKSDKERR)stopRefreshPairVerifyCode;

/// [en] This interface is used to end projection. [cn] 结束投屏
- (void)endProjectionWithParam:(HWMUISDKEndProjectionParamModel *)param callback:(HWMSDKEndProjectionHandler)callback;

/// [en] This interface is used to switch projection to conf. [cn] 投屏会议转普通会议
- (void)switchProjectionToConfWithCallback:(HWMSDKSwitchProjectionToConfHandler)callback;

/// [en]This interface is used to query version info. [cn]查询版本信息
- (void)queryVersionInfo:(HWMUISDKVersionInfoModel *)info callback:(HWMSDKQueryVersionInfoHandler)callback;

/// [en]This class is about init pair server. [cn]初始化配对服务
- (void)initPairServerWithInfo:(HWMUISDKInitPairInfoModel *)info;

/// [en] This interface is update external invitees info. [cn] 更新外部邀请者
- (void)updateExternalInviteesList:(HWMUISDKExternalInviteesInfoModel *)list callback:(HWMSDKUpdateExternalInviteesListHandler)callback;

/// [en] This interface is used to playing the audio file. [cn] 开始播放音频文件
- (void)startPlayAudioFileWithParam:(HWMUISDKStartPlayAudioFileParamModel *)param callback:(HWMSDKStartPlayAudioFileHandler)callback;

/// [en] This interface is used to stop playing audio files. [cn] 停止播放音频文件
- (HWMUISDKSDKERR)stopPlayAudioFile;

/// [en] This interface is used to set other's number. [cn] 设置其他号码
- (void)setOtherNumberWithInfo:(HWMUISDKOtherNumberInfoModel *)info callback:(HWMSDKSetOtherNumberHandler)callback;

/// [en] This interface is set deploy info [cn] 设置部署信息
- (void)setDeployInfo:(HWMUISDKDeployInfoModel *)info callback:(HWMSDKSetDeployInfoHandler)callback;

/// [en] This interface is set inner http proxy info [cn] 设置内部Http代理信息
- (void)setInnerHttpProxyInfo:(HWMUISDKInnerHttpProxyInfoModel *)info callback:(HWMSDKSetInnerHttpProxyInfoHandler)callback;

/// [en] This interface is set meeting custom info [cn] 设置会议自定义信息
- (void)setMeetingCustomInfo:(HWMUISDKMeetingCustomInfoModel *)info callback:(HWMSDKSetMeetingCustomInfoHandler)callback;

/// [en] This interface is get JwtToken info. [cn] 本地鉴权token信息
- (HWMUISDKJwtTokenInfoModel *)getJwtToken;

@end



NS_ASSUME_NONNULL_END

