//
//  HWMJoinConfParam.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/12.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMBaseJoinConfParam.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMJoinConfParam : HWMBaseJoinConfParam
/// 会议密码。若希望以主席身份入会，必须传入主席密码。
/// 若希望以来宾身份入会，会议要求来宾密码时，必现传入来宾密码，会议不要求来宾密码时，可以为空。
@property(nonatomic, copy) NSString *password;

/// 强制结束和当前VMR会议资源冲突的会议（必需是vmr资源的拥有者才有权限，否则无效）
@property(nonatomic, assign)BOOL isStopConflictConf;

/// 是否隐藏密码弹窗，默认NO。只对Mac生效
@property (nonatomic, assign) BOOL isHidePasswordAlert;

@end

NS_ASSUME_NONNULL_END
