//
//  HWMSDKPrivateLoginService.h
//  HWMSDKSDK
//
//  Automatically generated file. DO NOT MODIFY!!!
//

#import <Foundation/Foundation.h>
#import "HWMSDKCommonDefine.h"
#import "HWMSDKAllModelIndex.h"

NS_ASSUME_NONNULL_BEGIN

typedef void(^HWMSDKLoginBySSOSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResult);
typedef void(^HWMSDKLoginBySSOFailedBlock) (NSError * _Nullable error, HWMSDKLoginPrivateResultInfoModel * loginResult);

typedef void(^HWMSDKSendReqVerifyCodeSuccessBlock) (HWMSDKReqVerifyCodeResultInfoModel * verifyCodeResultInfo);
typedef void(^HWMSDKSendReqVerifyCodeFailedBlock) (NSError * _Nullable error, HWMSDKReqVerifyCodeResultInfoModel * verifyCodeResultInfo);

typedef void(^HWMSDKRegisterRequestVerifyCodeSuccessBlock) (NSUInteger expire);
typedef void(^HWMSDKRegisterRequestVerifyCodeFailedBlock) (NSError * _Nullable error, NSUInteger expire);

typedef void(^HWMSDKLoginPrivateSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginPrivateFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByAccountSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByAccountFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByMiddleTokenSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByMiddleTokenFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByRegisterSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByRegisterFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByUsgTokenSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByUsgTokenFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByVerifyCodeSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByVerifyCodeFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByWechatSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByWechatFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByThirdUserInfoSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByThirdUserInfoFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByAuthCodeSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByAuthCodeFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByAppIdPrivateSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByAppIdPrivateFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKLoginByNonceSuccessBlock) (HWMSDKLoginPrivateResultInfoModel * loginResultInfo);
typedef void(^HWMSDKLoginByNonceFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKRequestSliderSuccessBlock) (HWMSDKRequestSliderInfoResultModel * sliderInfoResult);
typedef void(^HWMSDKRequestSliderFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKCheckSliderSuccessBlock) (HWMSDKCheckSliderResultModel * checkResultInfo);
typedef void(^HWMSDKCheckSliderFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKResetPasswordSuccessBlock) (void);
typedef void(^HWMSDKResetPasswordFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKChangeUserConfigInfoSuccessBlock) (void);
typedef void(^HWMSDKChangeUserConfigInfoFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKBindAccountByWeChatSuccessBlock) (HWMSDKBindAccountInfoModel * bindInfo);
typedef void(^HWMSDKBindAccountByWeChatFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKRegisterCorpSuccessBlock) (NSString * corpId);
typedef void(^HWMSDKRegisterCorpFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKCheckVerifyCodeSuccessBlock) (HWMSDKCheckVerifyCodeResultModel * checkVerifyCodeResult);
typedef void(^HWMSDKCheckVerifyCodeFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKUserRegisterSuccessBlock) (NSString * token);
typedef void(^HWMSDKUserRegisterFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKUserRegisterPreVerifySuccessBlock) (HWMSDKPreVerifyResultModel * preVerifyResult);
typedef void(^HWMSDKUserRegisterPreVerifyFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKChangeRegisterPwdSuccessBlock) (void);
typedef void(^HWMSDKChangeRegisterPwdFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKCancelCorpSuccessBlock) (NSUInteger expire);
typedef void(^HWMSDKCancelCorpFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKRemoveDeviceBindingSuccessBlock) (void);
typedef void(^HWMSDKRemoveDeviceBindingFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKGetSSOAuthorizeUrlSuccessBlock) (NSString * ssoAuthorizeUrl);
typedef void(^HWMSDKGetSSOAuthorizeUrlFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryInvitationCodeSuccessBlock) (HWMSDKInvitationCodeInfoModel * invitationCode);
typedef void(^HWMSDKQueryInvitationCodeFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryCorpApplicantListSuccessBlock) (HWMSDKCorpApplicantListModel * content);
typedef void(^HWMSDKQueryCorpApplicantListFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKAcceptCorpApplicantSuccessBlock) (void);
typedef void(^HWMSDKAcceptCorpApplicantFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKRejectCorpApplicantSuccessBlock) (void);
typedef void(^HWMSDKRejectCorpApplicantFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKAcceptCorpApplicantAllSuccessBlock) (void);
typedef void(^HWMSDKAcceptCorpApplicantAllFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKRejectCorpApplicantAllSuccessBlock) (void);
typedef void(^HWMSDKRejectCorpApplicantAllFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryRegionInfoSuccessBlock) (HWMSDKRegionInfoModel * regionInfo);
typedef void(^HWMSDKQueryRegionInfoFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryRegionControlInfoSuccessBlock) (HWMSDKRegionControlInfoResultModel * regionControlInfo);
typedef void(^HWMSDKQueryRegionControlInfoFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryRegionControlInfoExSuccessBlock) (HWMSDKRegionControlInfoResultModel * regionControlInfo);
typedef void(^HWMSDKQueryRegionControlInfoExFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKScanPairCodeForJoinSuccessBlock) (void);
typedef void(^HWMSDKScanPairCodeForJoinFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKSubmitNssSurveySuccessBlock) (void);
typedef void(^HWMSDKSubmitNssSurveyFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKReportPairLinkSuccessBlock) (void);
typedef void(^HWMSDKReportPairLinkFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKUnbindPairLinkSuccessBlock) (void);
typedef void(^HWMSDKUnbindPairLinkFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQuerySSOSchemaConfigSuccessBlock) (HWMSDKSSOSchemaConfigResultModel * queryResult);
typedef void(^HWMSDKQuerySSOSchemaConfigFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKUnbindThirdAppSuccessBlock) (void);
typedef void(^HWMSDKUnbindThirdAppFailedBlock) (NSError * _Nullable error);

typedef void(^HWMSDKQueryCaCertVersionSuccessBlock) (HWMSDKQueryCaVersionInfoResultModel * queryResult);
typedef void(^HWMSDKQueryCaCertVersionFailedBlock) (NSError * _Nullable error);


@protocol HWMSDKPrivateLoginNotify <NSObject>

@optional
/// [en]This class is about the notifications of the login status information containing the private information. [cn]登录状态信息通知,包含私有信息 :imLogin
- (void)onLoginPrivateStateInfoChanged:(HWMSDKLoginPrivateStateInfoModel *)loginStatusInfo;
/// [en]This class is about the downloaded configuration information report.The synchronized method is GetConfigInfo. [cn]下载的配置信息上报 同步方法GetConfigInfo
- (void)onConfigInfoChanged:(NSString *)config;
/// [en]This class is about the usg json configuration information report. [cn]UsgJson配置信息上报
- (void)onAppConfigChanged:(NSString *)config;
/// [en]This class is about the user configuration change.The synchronized method is GetUserConfigInfo. [cn]用户个人高级配置变更 同步方法GetUserConfigInfo
- (void)onUserConfigInfoChanged:(HWMSDKUserConfigParamModel *)config;
/// [en]This class is about the enterprise configuration change.The synchronized method is GetCorpConfigInfo. [cn]企业配置变更 同步方法GetCorpConfigInfo
- (void)onCorpConfigInfoChanged:(HWMSDKCorpConfigParamModel *)config;
/// [en]This class is about the server domain name strategy change. [cn]域名策略变更
- (void)onServerDomainNameStrategyChanged:(HWMSDKServerDomainStrategyModel *)domainStrategy;
/// [en]This class is about the vmr configuration change.The synchronized method is GetUserVmrConfigInfo. [cn]用户vmr信息变化 同步方法GetUserVmrConfigInfo
- (void)onUserVmrConfigInfoChanged:(HWMSDKUserVmrConfigInfoModel *)vmrConfigInfo;
/// [en]This class is about the confnotice info Notification. [cn]usg 推送会议公告信息到客户端
- (void)onConfNoticeNotify:(HWMSDKLoginConfNoticeNotifyInfoModel *)conNoticeInfo;
/// [en]Notify pair code change. [cn]通知配对码变化 :disable
- (void)onRequestPairCodeNotify:(HWMSDKProjectionCodeInfoModel *)pairCodeResult;
/// [en]This class is about the notifications of join corp auditing [cn] 加入企业申请通知
- (void)onJoinCorpAuditing;
/// [en]This class is about the notifications of corp invitation setting changed [cn] 企业邀请设置变更通知
- (void)onInvitationSettingChanged:(BOOL)isCorpEnableInvitation;
/// [en]This class is about the enterprise type change. [cn]企业类型变更
- (void)onCorpTypeInfoChanged:(HWMLoginCorpType)corpType;
/// [en]This class is about the share vmr change. [cn]共享vmr变更
- (void)onShareVmrInfoNotify:(HWMSDKShareVmrInfoModel *)shareVmrInfo;
/// [en]This class is about the notifications of collect media separate log. [cn]媒体分离日志收集完毕通知
- (void)onRequestMediaSeparateLogNotify:(HWMSDKERR)result reasonDesc:(NSString *)reasonDesc;
/// [en]This class is about the site switch notify. [cn]节点切换的通知
- (void)onSiteSwitchNotify:(NSString *)redirectHost;
/// [en]This class is about the ca verify expired. [cn]证书校验过期
- (void)onCaVerifyExpired;

@end

@interface HWMSDKPrivateLoginService : NSObject

+ (instancetype)shareInstance;
+ (void)releaseInstance;
- (void)addPrivateLoginNotifyCallback:(id<HWMSDKPrivateLoginNotify>)callback;
- (void)removePrivateLoginNotifyCallback:(id<HWMSDKPrivateLoginNotify>)callback;
/// [en] This is about set client type. [cn] 设置客户端类型
- (HWMSDKERR)setClientTypeWithClientInfo:(HWMSDKClientInfoModel *)clientInfo;

/// [en]This class is about login. [cn]登录
- (void)loginPrivateWithLoginInfo:(HWMSDKLoginInfoPrivateModel *)loginInfo successCallback:(HWMSDKLoginPrivateSuccessBlock)successCallback failedCallback:(HWMSDKLoginPrivateFailedBlock)failedCallback;

/// [en] This is about login by accunt auth info. [cn] 账号鉴权 :rename:Login
- (void)loginWithAccountAuthInfo:(HWMSDKAccountAuthInfoModel *)accountAuthInfo successCallback:(HWMSDKLoginByAccountSuccessBlock)successCallback failedCallback:(HWMSDKLoginByAccountFailedBlock)failedCallback;

/// [en] This is about login by MiddleTokenAuthInfo. [cn] 中台token鉴权 :rename:Login
- (void)loginWithMiddleTokenAuthInfo:(HWMSDKMiddleTokenAuthInfoModel *)middleTokenAuthInfo successCallback:(HWMSDKLoginByMiddleTokenSuccessBlock)successCallback failedCallback:(HWMSDKLoginByMiddleTokenFailedBlock)failedCallback;

/// [en] This is about login by AuthCodeAuthInfo. [cn] 智慧屏鉴权 :rename:Login
- (void)loginWithAuthCodeAuthInfo:(HWMSDKAuthCodeAuthInfoModel *)authCodeAuthInfo successCallback:(HWMSDKLoginByAuthCodeSuccessBlock)successCallback failedCallback:(HWMSDKLoginByAuthCodeFailedBlock)failedCallback;

/// [en] This is about login by RegisterAuthInfo. [cn] 注册鉴权 :rename:Login
- (void)loginWithRegisterAuthInfo:(HWMSDKRegisterAuthInfoModel *)registerAuthInfo successCallback:(HWMSDKLoginByRegisterSuccessBlock)successCallback failedCallback:(HWMSDKLoginByRegisterFailedBlock)failedCallback;

/// [en] This is about login by UsgTokenAuthInfo. [cn] usg长token鉴权 :rename:Login
- (void)loginWithUsgTokenAuthInfo:(HWMSDKUsgTokenAuthInfoModel *)usgTokenAuthInfo successCallback:(HWMSDKLoginByUsgTokenSuccessBlock)successCallback failedCallback:(HWMSDKLoginByUsgTokenFailedBlock)failedCallback;

/// [en] This is about login by VerifyCodeAuthInfo. [cn] 验证码鉴权 :rename:Login
- (void)loginWithVerifyCodeAuthInfo:(HWMSDKVerifyCodeAuthInfoModel *)verifyCodeAuthInfo successCallback:(HWMSDKLoginByVerifyCodeSuccessBlock)successCallback failedCallback:(HWMSDKLoginByVerifyCodeFailedBlock)failedCallback;

/// [en] This is about login by WechatAuthInfo. [cn] 微信登录鉴权 :rename:Login
- (void)loginWithWeChatAuthInfo:(HWMSDKWechatAuthInfoModel *)weChatAuthInfo successCallback:(HWMSDKLoginByWechatSuccessBlock)successCallback failedCallback:(HWMSDKLoginByWechatFailedBlock)failedCallback;

/// [en] This is about login by SSOAuthInfo. [cn] sso code鉴权 :rename:Login
- (void)loginWithSsoAuthInfo:(HWMSDKSSOAuthInfoModel *)ssoAuthInfo successCallback:(HWMSDKLoginBySSOSuccessBlock)successCallback failedCallback:(HWMSDKLoginBySSOFailedBlock)failedCallback;

/// [en] This is about login by third user info. [cn] 第三方用户缓存信息鉴权 :rename:Login
- (void)loginWithThirdUserInfo:(HWMSDKThirdUserInfoModel *)thirdUserInfo successCallback:(HWMSDKLoginByThirdUserInfoSuccessBlock)successCallback failedCallback:(HWMSDKLoginByThirdUserInfoFailedBlock)failedCallback;

/// [en] This is about login by AppIdAuthInfo. [cn] AppId鉴权
- (void)loginByAppIdPrivateWithAppIdAuthInfo:(HWMSDKAppIdAuthInfoModel *)appIdAuthInfo successCallback:(HWMSDKLoginByAppIdPrivateSuccessBlock)successCallback failedCallback:(HWMSDKLoginByAppIdPrivateFailedBlock)failedCallback;

/// [en] This is about login by NonceAuthInfo. [cn] Nonce鉴权
- (void)loginByNonceWithNonceAuthInfo:(HWMSDKNonceAuthInfoModel *)nonceAuthInfo successCallback:(HWMSDKLoginByNonceSuccessBlock)successCallback failedCallback:(HWMSDKLoginByNonceFailedBlock)failedCallback;

/// [en]This class is about a synchronous method to get login information. [cn]获取登录信息
- (HWMSDKLoginPrivateStateInfoModel *)getLoginPrivateStateInfo;

/// [en]This class is about changing register password. [cn]修改注册时的密码
- (void)changeRegisterPwdWithParam:(HWMSDKRegisterPwdParamModel *)param successCallback:(HWMSDKChangeRegisterPwdSuccessBlock)successCallback failedCallback:(HWMSDKChangeRegisterPwdFailedBlock)failedCallback;

/// [en]This class is about resetting the password. [cn]重置密码
- (void)resetPasswordWithParam:(HWMSDKResetPasswordParamModel *)param successCallback:(HWMSDKResetPasswordSuccessBlock)successCallback failedCallback:(HWMSDKResetPasswordFailedBlock)failedCallback;

/// [en]This class is about changing user config info. [cn]修改用户个人高级配置信息
- (void)changeUserConfigInfoWithParam:(HWMSDKUserCfgParamListModel *)param successCallback:(HWMSDKChangeUserConfigInfoSuccessBlock)successCallback failedCallback:(HWMSDKChangeUserConfigInfoFailedBlock)failedCallback;

/// [en]This class is about a synchronous method to get enterprise configuration information. [cn]获取用户个人高级配置信息
- (HWMSDKUserConfigParamModel *)getUserConfigInfo;

/// [en] [cn]用户注册前置校验
- (void)userRegisterPreVerifyWithParam:(HWMSDKPreVerifyParamModel *)param successCallback:(HWMSDKUserRegisterPreVerifySuccessBlock)successCallback failedCallback:(HWMSDKUserRegisterPreVerifyFailedBlock)failedCallback;

/// [en]This class is about user registration. [cn]用户注册
- (void)userRegisterWithParam:(HWMSDKUserRegParamModel *)param successCallback:(HWMSDKUserRegisterSuccessBlock)successCallback failedCallback:(HWMSDKUserRegisterFailedBlock)failedCallback;

/// [en]This class is about a synchronous method to get login configuration information. [cn]获取登录配置信息
- (NSString *)getConfigInfo;

/// [en]This class is about Request verification code. [cn]请求验证码
- (void)sendReqVerifyCodeWithParam:(HWMSDKReqVerifyCodeParamModel *)param successCallback:(HWMSDKSendReqVerifyCodeSuccessBlock)successCallback failedCallback:(HWMSDKSendReqVerifyCodeFailedBlock)failedCallback;

/// [en]This class is about Check verification code. [cn]校验验证码
- (void)checkVerifyCodeWithParam:(HWMSDKCheckVerifyCodeParamModel *)param successCallback:(HWMSDKCheckVerifyCodeSuccessBlock)successCallback failedCallback:(HWMSDKCheckVerifyCodeFailedBlock)failedCallback;

/// [en]This class is about registering enterprise . [cn]注册企业
- (void)registerCorpWithParam:(HWMSDKRegisterCorpParamModel *)param successCallback:(HWMSDKRegisterCorpSuccessBlock)successCallback failedCallback:(HWMSDKRegisterCorpFailedBlock)failedCallback;

/// [en]This class is about cancelling enterprise. [cn]注销企业
- (void)cancelCorpWithParam:(NSString *)param successCallback:(HWMSDKCancelCorpSuccessBlock)successCallback failedCallback:(HWMSDKCancelCorpFailedBlock)failedCallback;

/// [en]This class is about request verification code used for registration . [cn]注册时请求验证码
- (void)registerRequestVerifyCodeWithRegisterVerifyInfo:(HWMSDKRegisterVerifyInfoModel *)registerVerifyInfo successCallback:(HWMSDKRegisterRequestVerifyCodeSuccessBlock)successCallback failedCallback:(HWMSDKRegisterRequestVerifyCodeFailedBlock)failedCallback;

/// [en]This class is about request slider block. [cn]请求滑块
- (void)requestSliderWithRequestSliderInfo:(HWMSDKRequestSliderInfoModel *)requestSliderInfo successCallback:(HWMSDKRequestSliderSuccessBlock)successCallback failedCallback:(HWMSDKRequestSliderFailedBlock)failedCallback;

/// [en]This class is about verifying slider block. [cn]校验滑块
- (void)checkSliderWithCheckSliderInfo:(HWMSDKCheckSliderInfoModel *)checkSliderInfo successCallback:(HWMSDKCheckSliderSuccessBlock)successCallback failedCallback:(HWMSDKCheckSliderFailedBlock)failedCallback;

/// [en]This class is about refreshing middleground token. [cn]刷新中台token
- (HWMSDKERR)refreshMiddleGroundToken;

/// [en]This class is about a synchronous method to get new accessToken. [cn]获取新的accessToken
- (HWMSDKERR)refreshAccessToken;

/// [en]This interface is used to bind WeChat account. [cn]绑定微信帐号
- (void)bindAccountByWeChatWithWechatMessage:(HWMSDKBindWechatInfoModel *)wechatMessage successCallback:(HWMSDKBindAccountByWeChatSuccessBlock)successCallback failedCallback:(HWMSDKBindAccountByWeChatFailedBlock)failedCallback;

/// [en]This class is about a synchronous method to remove device binding. [cn]解除设备绑定
- (void)removeDeviceBindingWithSuccessCallback:(HWMSDKRemoveDeviceBindingSuccessBlock)successCallback failedCallback:(HWMSDKRemoveDeviceBindingFailedBlock)failedCallback;

/// [en]Get SSO Authorize Url. [cn]获取SSO鉴权url
- (void)getSSOAuthorizeUrlWithDomain:(NSString *)domain successCallback:(HWMSDKGetSSOAuthorizeUrlSuccessBlock)successCallback failedCallback:(HWMSDKGetSSOAuthorizeUrlFailedBlock)failedCallback;

/// [en]This class is about getting the list of all the vmr info. [cn]获取所有的与会者
- (NSArray <HWMSDKVmrInfoModel *> *)getVmrInfoList;

/// [en]This class is about query invitation code. [cn]获取邀请码
- (void)queryInvitationCodeWithChannelPartner:(NSString *)channelPartner successCallback:(HWMSDKQueryInvitationCodeSuccessBlock)successCallback failedCallback:(HWMSDKQueryInvitationCodeFailedBlock)failedCallback;

/// [en]This class is about a synchronous method to get conf notice information. [cn]获取会议公告新鲜
- (HWMSDKLoginConfNoticeNotifyInfoModel *)getLatestConfNoticeInfo;

/// [en]Get conf notice. [cn]获取conf notice信息
- (HWMSDKERR)setLatestConfNoticeChecked;

/// [en] [cn]提交满意度评价
- (void)submitNssSurveyWithParam:(HWMSDKLoginNssSurveyParamModel *)param successCallback:(HWMSDKSubmitNssSurveySuccessBlock)successCallback failedCallback:(HWMSDKSubmitNssSurveyFailedBlock)failedCallback;

/// [en] This class is about query corp applicant list [cn] 获取企业申请人员列表
- (void)queryCorpApplicantListWithParam:(HWMSDKQueryCorpApplicantListParamModel *)param successCallback:(HWMSDKQueryCorpApplicantListSuccessBlock)successCallback failedCallback:(HWMSDKQueryCorpApplicantListFailedBlock)failedCallback;

/// [en] This class is about accept corp applicant [cn] 企业申请审核同意
- (void)acceptCorpApplicantWithUserid:(NSString *)userid successCallback:(HWMSDKAcceptCorpApplicantSuccessBlock)successCallback failedCallback:(HWMSDKAcceptCorpApplicantFailedBlock)failedCallback;

/// [en] This class is about reject corp applicant [cn] 企业申请审核拒绝
- (void)rejectCorpApplicantWithUserid:(NSString *)userid successCallback:(HWMSDKRejectCorpApplicantSuccessBlock)successCallback failedCallback:(HWMSDKRejectCorpApplicantFailedBlock)failedCallback;

/// [en] This class is about accept all corp applicant [cn] 企业申请审核全部同意
- (void)acceptCorpApplicantAllWithSuccessCallback:(HWMSDKAcceptCorpApplicantAllSuccessBlock)successCallback failedCallback:(HWMSDKAcceptCorpApplicantAllFailedBlock)failedCallback;

/// [en] This class is about reject corp all applicant [cn] 企业申请审核全部拒绝
- (void)rejectCorpApplicantAllWithSuccessCallback:(HWMSDKRejectCorpApplicantAllSuccessBlock)successCallback failedCallback:(HWMSDKRejectCorpApplicantAllFailedBlock)failedCallback;

/// [en]This class is about query regin info [cn]查询会议所在Region信息
- (void)queryRegionInfoWithParam:(HWMSDKQueryRegionInfoParamModel *)param successCallback:(HWMSDKQueryRegionInfoSuccessBlock)successCallback failedCallback:(HWMSDKQueryRegionInfoFailedBlock)failedCallback;

/// [en]This class is about query regin control info [cn]查询会议所在Region信息
- (void)queryRegionControlInfoWithParam:(HWMSDKQueryRegionControlInfoParamModel *)param successCallback:(HWMSDKQueryRegionControlInfoSuccessBlock)successCallback failedCallback:(HWMSDKQueryRegionControlInfoFailedBlock)failedCallback;

/// [en]This class is about query regin control info [cn]查询会议所在Region信息，支持来宾/主持人
- (void)queryRegionControlInfoExWithParam:(HWMSDKQueryRegionControlInfoExParamModel *)param successCallback:(HWMSDKQueryRegionControlInfoExSuccessBlock)successCallback failedCallback:(HWMSDKQueryRegionControlInfoExFailedBlock)failedCallback;

/// [en]This class is about scan pair code for join info [cn]扫描配对码以邀请入会
- (void)scanPairCodeForJoinWithParam:(HWMSDKScanJoinConfParamModel *)param successCallback:(HWMSDKScanPairCodeForJoinSuccessBlock)successCallback failedCallback:(HWMSDKScanPairCodeForJoinFailedBlock)failedCallback;

/// [en]This class is about report pair link info. [cn]上报配对链路信息
- (void)reportPairLinkWithReportPairLinkInfo:(HWMSDKReportPairLinkInfoModel *)reportPairLinkInfo successCallback:(HWMSDKReportPairLinkSuccessBlock)successCallback failedCallback:(HWMSDKReportPairLinkFailedBlock)failedCallback;

/// [en]This class is about unbind pair link. [cn]解除配对链路关系
- (void)unbindPairLinkWithUnbindPairLinkInfo:(HWMSDKUnbindPairLinkInfoModel *)unbindPairLinkInfo successCallback:(HWMSDKUnbindPairLinkSuccessBlock)successCallback failedCallback:(HWMSDKUnbindPairLinkFailedBlock)failedCallback;

/// [en]Get SSO Schema配置项. [cn]获取SSO schema配置项
- (void)querySSOSchemaConfigWithDomain:(NSString *)domain successCallback:(HWMSDKQuerySSOSchemaConfigSuccessBlock)successCallback failedCallback:(HWMSDKQuerySSOSchemaConfigFailedBlock)failedCallback;

/// [en]This class is about unbind third app. [cn]解除第三方应用
- (void)unbindThirdAppWithThirdAppInfo:(HWMSDKThirdAppInfoModel *)thirdAppInfo successCallback:(HWMSDKUnbindThirdAppSuccessBlock)successCallback failedCallback:(HWMSDKUnbindThirdAppFailedBlock)failedCallback;

/// [en]This interface is used to request media separate log. [cn]请求媒体分离日志 :disable
- (HWMSDKERR)requestMediaSeparateLog;

/// [en]This class is about query ca version. [cn]请求证书版本
- (void)queryCaCertVersionWithCaVersionInfo:(HWMSDKCaVersionInfoModel *)caVersionInfo successCallback:(HWMSDKQueryCaCertVersionSuccessBlock)successCallback failedCallback:(HWMSDKQueryCaCertVersionFailedBlock)failedCallback;

- (void)cleanLoginPrivateCallbacks;
- (void)cleanLoginByAccountCallbacks;
- (void)cleanLoginByMiddleTokenCallbacks;
- (void)cleanLoginByAuthCodeCallbacks;
- (void)cleanLoginByRegisterCallbacks;
- (void)cleanLoginByUsgTokenCallbacks;
- (void)cleanLoginByVerifyCodeCallbacks;
- (void)cleanLoginByWechatCallbacks;
- (void)cleanLoginBySSOCallbacks;
- (void)cleanLoginByThirdUserInfoCallbacks;
- (void)cleanLoginByAppIdPrivateCallbacks;
- (void)cleanLoginByNonceCallbacks;
- (void)cleanChangeRegisterPwdCallbacks;
- (void)cleanResetPasswordCallbacks;
- (void)cleanChangeUserConfigInfoCallbacks;
- (void)cleanUserRegisterPreVerifyCallbacks;
- (void)cleanUserRegisterCallbacks;
- (void)cleanSendReqVerifyCodeCallbacks;
- (void)cleanCheckVerifyCodeCallbacks;
- (void)cleanRegisterCorpCallbacks;
- (void)cleanCancelCorpCallbacks;
- (void)cleanRegisterRequestVerifyCodeCallbacks;
- (void)cleanRequestSliderCallbacks;
- (void)cleanCheckSliderCallbacks;
- (void)cleanBindAccountByWeChatCallbacks;
- (void)cleanRemoveDeviceBindingCallbacks;
- (void)cleanGetSSOAuthorizeUrlCallbacks;
- (void)cleanQueryInvitationCodeCallbacks;
- (void)cleanSubmitNssSurveyCallbacks;
- (void)cleanQueryCorpApplicantListCallbacks;
- (void)cleanAcceptCorpApplicantCallbacks;
- (void)cleanRejectCorpApplicantCallbacks;
- (void)cleanAcceptCorpApplicantAllCallbacks;
- (void)cleanRejectCorpApplicantAllCallbacks;
- (void)cleanQueryRegionInfoCallbacks;
- (void)cleanQueryRegionControlInfoCallbacks;
- (void)cleanQueryRegionControlInfoExCallbacks;
- (void)cleanScanPairCodeForJoinCallbacks;
- (void)cleanReportPairLinkCallbacks;
- (void)cleanUnbindPairLinkCallbacks;
- (void)cleanQuerySSOSchemaConfigCallbacks;
- (void)cleanUnbindThirdAppCallbacks;
- (void)cleanQueryCaCertVersionCallbacks;
@end



NS_ASSUME_NONNULL_END

