//
//  HWMConsoleView.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/24.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMConsoleView.h"

@interface HWMConsoleView ()

/// scrollView
@property (nonatomic, strong) NSScrollView *scrollView;
/// 显示文本
@property (nonatomic, strong) NSTextView *textView;

@end

@implementation HWMConsoleView

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        [self setupUI];
        [HWMConsoleManager shareInstance].consoleView = self;
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    [self setupScrollViewFrame];
}

#pragma mark - UI
- (void)setupUI {
    self.wantsLayer = YES;
    self.layer.backgroundColor = [NSColor whiteColor].CGColor;
    self.layer.borderColor = [NSColor colorWithRGB:0xEEEEEE].CGColor;
    self.layer.borderWidth = 1.0;
    
    self.scrollView = [[NSScrollView alloc] init];
    [self.scrollView setHasVerticalScroller:YES];
    [self.scrollView setHasHorizontalScroller:NO];
    [self.scrollView setBorderType:NSNoBorder];
    [self.scrollView setDrawsBackground:NO];
    [self.scrollView setAutohidesScrollers:YES];
    [self.scrollView setHorizontalScrollElasticity:NSScrollElasticityNone];
    [self.scrollView setVerticalScrollElasticity:NSScrollElasticityNone];
    [self addSubview:self.scrollView];
    
    self.textView = [[NSTextView alloc] init];
    self.textView.wantsLayer = YES;
    self.textView.layer.masksToBounds = YES;
    [self.textView setDrawsBackground:NO];
    [self.textView setVerticallyResizable:YES];
    [self.textView setHorizontallyResizable:NO];
    [self.textView setAutomaticLinkDetectionEnabled:NO];
    [[self.textView textContainer] setWidthTracksTextView:YES];
    [self.textView setTextContainerInset:NSMakeSize(10, 10)];
    [self.textView setEditable:NO];
    [self.textView setFont:[NSFont systemFontOfSize:12.0]];
    [self.textView setTextColor:[NSColor blackColor]];
    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    [paragraphStyle setLineSpacing:4.0];
    [self.textView setDefaultParagraphStyle:paragraphStyle];
    self.scrollView.contentView.documentView = self.textView;
    
}

- (void)setupScrollViewFrame {
    self.scrollView.frame = self.bounds;
    self.textView.frame = self.scrollView.bounds;
}

- (void)setConsole:(NSString *)console {
    _console = console;
    dispatch_async(dispatch_get_main_queue(), ^{
        self.textView.string = console;
        [self scrollToBottom];
    });
}

- (void)scrollToBottom {
    CGFloat contentH = [[self.textView.enclosingScrollView documentView] bounds].size.height;
    CGFloat visibleH = self.textView.enclosingScrollView.documentVisibleRect.size.height;
    if (contentH > visibleH) {
        [self.textView.enclosingScrollView setLineScroll:0.0f];
        [self.textView.enclosingScrollView setPageScroll:0.0f];
        [[self.textView.enclosingScrollView contentView] scrollToPoint:NSMakePoint(0, contentH)];
        [self.scrollView reflectScrolledClipView:self.scrollView.contentView];
    }
}

@end
