//
//  HWMNavigationBar.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/2.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMNavigationBar.h"
#import "HWMNavigationItem.h"

@interface HWMNavigationBar ()
@property (nonatomic, strong) NSView *leftView;
@property (nonatomic, strong) NSView *rightView;
@end

@implementation HWMNavigationBar

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

- (instancetype)init {
    if (self = [super init]) {
        [self initView];
    }
    return self;
}

- (void)initView {
    self.wantsLayer = YES;
    self.layer.backgroundColor = [NSColor clearColor].CGColor;

    self.leftView = [NSView new];
    [self addSubview:self.leftView];
    [self.leftView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.top.bottom.equalTo(self);
        make.width.equalTo(self).multipliedBy(1 / 3.0);
    }];
    
    self.rightView = [NSView new];
    [self addSubview:self.rightView];
    [self.rightView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.top.bottom.equalTo(self);
        make.width.equalTo(self).multipliedBy(1 / 3.0);
    }];
}

- (void)setBackItem:(HWMNavigationItem *)backItem {
    [_backItem.view removeFromSuperview];
    _backItem = backItem;
    [self.leftView addSubview:backItem.view];
    [backItem.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.offset(24);
        make.centerY.equalTo(self.leftView);
    }];
}

- (void)setRightItem:(HWMNavigationItem *)rightItem {
    [_rightItem.view removeFromSuperview];
    _rightItem = rightItem;
    [self.rightView addSubview:rightItem.view];
    [rightItem.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.offset(-24);
        make.centerY.equalTo(self.rightView);
    }];
}

@end
