//
//  HWMSDKTableView.h
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/11/5.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

@protocol HWMSDKTableViewDelegate <NSTableViewDelegate>

@end

@protocol HWMSDKTableViewDataSourse <NSTableViewDataSource>

@end


@interface HWMSDKTableView : NSView

- (instancetype)initTableViewClomuIdentifier:(NSString *)identifier;

/// 列表
@property (nonatomic, strong) NSTableView *listView;
/// 滚动视图
@property (nonatomic, strong) NSScrollView *scrollView;

/// delegate
@property (nonatomic, weak) id<HWMSDKTableViewDelegate> delegate;
/// datasource
@property (nonatomic, weak) id<HWMSDKTableViewDataSourse> dataSource;

- (void)reloadData;

@end

NS_ASSUME_NONNULL_END
