//
//  HWMSDKTableView.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/11/5.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSDKTableView.h"

@interface HWMSDKTableView ()

/// identifer
@property (nonatomic, strong) NSString *columnIdentifier;

@end

@implementation HWMSDKTableView

- (instancetype)initTableViewClomuIdentifier:(NSString *)identifier {
    if (self = [super initWithFrame:NSZeroRect]) {
        self.columnIdentifier = identifier.length > 0 ? identifier : @"HWMSDKTableView";
        [self setupUI];
    }
    return self;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.wantsLayer = YES;
    self.layer.backgroundColor = [NSColor whiteColor].CGColor;
    self.scrollView = [[NSScrollView alloc] init];
    [self.scrollView setHasVerticalScroller:YES];
    [self.scrollView setHasHorizontalScroller:NO];
    [self.scrollView setBorderType:NSNoBorder];
    [self.scrollView setDrawsBackground:NO];
    [self.scrollView setAutohidesScrollers:YES];
    [self.scrollView setHorizontalScrollElasticity:NSScrollElasticityNone];
    [self.scrollView setVerticalScrollElasticity:NSScrollElasticityNone];
    [self addSubview:self.scrollView];

    self.listView = [[NSTableView alloc] init];
    self.listView.backgroundColor = [NSColor whiteColor];
    self.listView.selectionHighlightStyle = NSTableViewSelectionHighlightStyleNone;
    NSTableHeaderView *headerView = [[NSTableHeaderView alloc] initWithFrame:NSZeroRect];
    self.listView.headerView = headerView;
    NSTableColumn *colmn = [[NSTableColumn alloc] initWithIdentifier:self.columnIdentifier];
    [self.listView addTableColumn:colmn];
    self.scrollView.documentView = self.listView;

    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];
}

- (void)setDelegate:(id<HWMSDKTableViewDelegate>)delegate {
    _delegate = delegate;
    self.listView.delegate = delegate;
}

- (void)setDataSource:(id<HWMSDKTableViewDataSourse>)dataSource {
    _dataSource = dataSource;
    self.listView.dataSource = dataSource;
}

- (void)reloadData {
    [self.listView reloadData];
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

@end
