//
//  HWMConfListViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/28.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMConfListViewController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMConfListItem.h"
#import "HWMConfDetailViewController.h"
#import "NSViewController+HWMNavigation.h"
#import "HWMSDKTableView.h"

@interface HWMConfListViewController ()<HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate, HWMBizNotificationHandler>
/// tableView
@property (nonatomic, strong) HWMSDKTableView *listView;
/// 数据
@property (nonatomic, strong) NSMutableArray<HWMConfListItemInfo *> *dataArr;

@end

@implementation HWMConfListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do view setup here.
    [self setupUI];
}

- (void)viewWillAppear {
    [super viewWillAppear];
    [self loadData];
    if([HWMSdk hasInit]) {
        /// 订阅要在初始化后根据需要设置
        [[HWMSdk getSdkConfig] subscribeBizNotificationHandler:self];
    }
}

- (void)viewWillDisappear {
    [super viewWillDisappear];
    if([HWMSdk hasInit]) {
        [[HWMSdk getSdkConfig] unsubscribeBizNotificationHandler:self];
    }
}

#pragma mark - Data
- (void)loadData {
    if (![HWMSdk hasInit]) {
        return;
    }
   
    dispatch_async(dispatch_get_global_queue(0, 0), ^{
        [self.dataArr removeAllObjects];
        NSArray *arr = [[HWMBizSdk getBizOpenApi] getConfList];
        [self.dataArr addObjectsFromArray:arr];
        dispatch_async(dispatch_get_main_queue(), ^{
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"conf count: %lu", self.dataArr.count];
            [self.listView reloadData];
        });
    });
}

#pragma mark - UI
- (void)setupUI {
    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"confList"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.and.top.equalTo(self.view).offset(15);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.view).offset(-15);
    }];
}

#pragma mark - Event
- (void)joinConf:(HWMConfListItemInfo *)itemInfo {
    HWMJoinConfParam *joinParam = [[HWMJoinConfParam alloc] init];
    joinParam.confId = itemInfo.confId;
    joinParam.password = itemInfo.chairmanPwd.length > 0 ? itemInfo.chairmanPwd : itemInfo.generalPwd;

    [[HWMSdk getOpenApi] joinConfByPassword:joinParam callback:^(NSError *_Nullable error, id _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        } else {
            [HWMConsoleManager shareInstance].console = @"joined conf succeeded";
        }
    }];
}

#pragma mark - Delegate
- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.dataArr.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    HWMConfListItem *item = [HWMConfListItem initConfListItem:tableView ower:self];
    item.itemInfo = self.dataArr[row];
    @weakify(self)
    [item setJoinConfClickHandler:^(HWMConfListItemInfo *_Nonnull itemInfo) {
        @strongify(self)
        [self joinConf: itemInfo];
    }];
    return item;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 50.0;
}

- (BOOL)tableView:(NSTableView *)tableView shouldSelectRow:(NSInteger)row {
    HWMConfListItemInfo *info = self.dataArr[row];
    HWMConfDetailViewController *detail = [[HWMConfDetailViewController alloc] init];
    detail.confId = info.confId;
    [self.customNavigationController pushViewController:detail animated:YES];

    return YES;
}

- (void)onReceiveConfList:(NSArray<HWMConfListItemInfo *> *)confList {
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"%s -- %lu", __func__, confList.count];
    dispatch_async(dispatch_get_main_queue(), ^{
        [self.dataArr removeAllObjects];
        [self.dataArr addObjectsFromArray:confList];
        [self.listView reloadData];
    });

}

#pragma mark - Lazy
- (NSMutableArray<HWMConfListItemInfo *> *)dataArr {
    if (!_dataArr) {
        _dataArr = [NSMutableArray array];
    }
    return _dataArr;
}

@end
