//
//  HWMContactInfoController.m
//  HWMUISDKNativeDemo
//
//  Created by niecanxu on 2022/1/20.
//  Copyright © 2022 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMContactInfoController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMDataModel.h"
@interface HWMContactInfoController ()
@property (weak) IBOutlet NSTextField *account;
@property (weak) IBOutlet NSTextField *number;
@property (weak) IBOutlet NSTextField *phone;
@property (weak) IBOutlet NSTextField *deptDesc;
@property (weak) IBOutlet NSTextField *phoneShowType;
@property (weak) IBOutlet NSView *containerView;


@end

@implementation HWMContactInfoController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self.containerView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self.view);
        make.width.mas_equalTo(596);
        make.height.mas_equalTo(367);
    }];
}

- (IBAction)updateInfo:(id)sender {
    if (self.account.stringValue.length == 0) {
        [HWMConsoleManager shareInstance].console = @"账号不能为空";
        return;
    }
    if (self.number.stringValue.length == 0) {
        [HWMConsoleManager shareInstance].console = @"sip号不能为空";
        return;
    }
    HWMEnterpriseContact *contact = [HWMEnterpriseContact new];
    contact.account = self.account.stringValue;
    contact.number = self.number.stringValue;
    contact.phone = self.phone.stringValue;
    contact.deptDesc = self.deptDesc.stringValue;
    contact.phoneShowType = self.phoneShowType.stringValue.intValue;
    
    [[HWMDataModel sharedInstance].contacts addObject:contact];
    
    self.account.stringValue = @"";
    self.number.stringValue = @"";
    self.phone.stringValue = @"";
    self.deptDesc.stringValue = @"";
    self.phoneShowType.stringValue = @"";
    [HWMConsoleManager shareInstance].console = @"通讯录添加成功";
}

@end
