//
//  HWMEditVrmConfController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/2.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMEditVrmConfController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "NSViewController+HWMNavigation.h"
#import "HWMContentTitleViewCell.h"
#import "HWMInputInfoTitleCell.h"
#import "HWMSwitchCell.h"
#import "HWMJoinConfLimitCell.h"

@interface HWMEditVrmConfController ()<NSTableViewDelegate, NSTableViewDataSource, HWMInputInfoTitleCellDelegate,HWMSwitchCellDelegate>

/// tableView
@property (nonatomic, strong) NSTableView *listView;
/// scrollView
@property (nonatomic, strong) NSScrollView *scrollView;

@property (nonatomic, strong) NSButton *editBtn;
/// 会议主题
@property (nonatomic, copy) NSString *confSub;
/// 来宾密码
@property (nonatomic, copy) NSString *guestPwd;
/// 主持人密码
@property (nonatomic, copy) NSString *chairmainPwd;
/// 是否允许来宾提前入会
@property (nonatomic, assign) BOOL allowGuestStartConf;
/// 允许入会范围
@property (nonatomic, assign) HWMJoinConfRestrictionType confAllowJoinUser;
/// 是否启用等候室
@property (nonatomic, assign) BOOL isOpenWaitingRoom;

@end

@implementation HWMEditVrmConfController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self setupUI];
}

- (void)initData {
    self.confAllowJoinUser = self.vmrInfoModel.confAllowJoinUser;
    self.isOpenWaitingRoom = self.vmrInfoModel.isOpenWaitingRoom;
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.editBtn];
    [self.editBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];

    self.scrollView = [[NSScrollView alloc] init];
    [self.scrollView setHasVerticalScroller:YES];
    [self.scrollView setHasHorizontalScroller:NO];
    [self.scrollView setBorderType:NSNoBorder];
    [self.scrollView setDrawsBackground:NO];
    [self.scrollView setAutohidesScrollers:YES];
    [self.scrollView setHorizontalScrollElasticity:NSScrollElasticityNone];
    [self.scrollView setVerticalScrollElasticity:NSScrollElasticityNone];
    [self.view addSubview:self.scrollView];

    self.listView = [[NSTableView alloc] init];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    self.listView.backgroundColor = [NSColor whiteColor];
    self.listView.selectionHighlightStyle = NSTableViewSelectionHighlightStyleNone;
    NSTableHeaderView *headerView = [[NSTableHeaderView alloc] initWithFrame:NSZeroRect];
    self.listView.headerView = headerView;
    NSTableColumn *colmn = [[NSTableColumn alloc] initWithIdentifier:@"vrmConf"];
    [self.listView addTableColumn:colmn];
    self.scrollView.documentView = self.listView;

    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.view).offset(15);
        make.top.equalTo(self.view).offset(30);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.editBtn.mas_top).offset(-15);
    }];
}

- (void)setVmrInfoModel:(HWMVmrInfoModel *)vmrInfoModel {
    _vmrInfoModel = vmrInfoModel;
    _allowGuestStartConf = vmrInfoModel.allowGuestStartConf;
}

#pragma mark - Delegate
- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return 9;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    if (row == 6 || row == 8) {
        return [self switchCell:tableView row:row];
    }
    if (row == 1 || row == 2 || row == 5) {
        HWMContentTitleViewCell *cell = [HWMContentTitleViewCell initContentTitleCell:tableView ower:self];
        if (row == 1) {
            cell.title = @"会议ID";
            cell.content = self.vmrInfoModel.confId;
        } if (row == 2) {
            cell.title = @"vmrID";
            cell.content = self.vmrInfoModel.vmrId;
            
        }else {
            cell.title = @"会议类型";
            if (self.vmrInfoModel.type == HWMConfIdPersonal) {
                cell.content = @"个人会议";
            } else if (self.vmrInfoModel.type == HWMConfIdRandom) {
                cell.content = @"随机会议";
            } else {
                cell.content = @"云会议室";
            }
        }
        return cell;
    }
    
    if (row == 7) {
        HWMJoinConfLimitCell *cell = [HWMJoinConfLimitCell joinConfLimitCell:tableView ower:self];
        cell.menuTitles = @[@"所有人", @"仅企业内人员", @"仅会议邀请人员"];
        cell.title = @"允许入会";
        cell.currentIndex = self.confAllowJoinUser > 0 ? self.confAllowJoinUser - 1 : 0;
        @weakify(self)
        [cell setSelectMenuItemHandler:^(NSInteger index,NSString *_Nullable title) {
            @strongify(self)
            self.confAllowJoinUser = index > 0 ? index + 1 : 0;
        }];
        return cell;
    }

    HWMInputInfoTitleCell *cell = [HWMInputInfoTitleCell inputInfoTitleCell:tableView ower:self];

    if (row == 0) {
        cell.title = @"会议主题";
        cell.content = self.vmrInfoModel.name;
        cell.placeholder = @"请输入会议主题";
    } else if (row == 3) {
        cell.title = @"来宾密码";
        cell.content = self.vmrInfoModel.guestPwd;
        cell.placeholder = @"请输入来宾密码";
    } else {
        cell.title = @"主持人密码";
        cell.content = self.vmrInfoModel.chairmanPwd;
        cell.placeholder = @"请输入主持人密码";
    }
    cell.delegate = self;
    cell.index = row;
    return cell;
}

/// switch cell
- (HWMSwitchCell *)switchCell:(NSTableView *)tableView row:(NSInteger)row {
    HWMSwitchCell *cell = [HWMSwitchCell initSwitchCell:tableView ower:self];
    cell.index = row;
    if (row == 6) {
        cell.title = @"允许来宾提前入会";
        cell.state = self.vmrInfoModel.allowGuestStartConf;
    } else if (row == 8) {
        cell.title = @"开启等候室";
        cell.state = self.isOpenWaitingRoom;
    }
    cell.delegate = self;
    return cell;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 45.0;
}

- (void)inputInfoCellDidEdite:(NSString *)content index:(NSInteger)index {
    if (index == 0) {
        self.confSub = content;
    }else if (index == 3) {
        self.guestPwd = content;
    } else {
        self.chairmainPwd = content;
    }
}

#pragma mark - Event

- (void)editBtnClick {
    HWMModifyVMRParam *param = [[HWMModifyVMRParam alloc] init];
    param.chairPwd = self.chairmainPwd.length > 0 ? self.chairmainPwd : self.vmrInfoModel.chairmanPwd;
    param.vmrId = self.vmrInfoModel.vmrId;
    param.guestPwd = self.guestPwd.length == 0 ? @"" : self.guestPwd;
    param.vmrName = self.confSub.length > 0 ? self.confSub : self.vmrInfoModel.name;
    param.allowGuestStartConf = self.allowGuestStartConf;
    param.isOpenWaitingRoom = self.isOpenWaitingRoom;
    param.confAllowJoinUser = self.confAllowJoinUser;
    @weakify(self);
    [[HWMBizSdk getBizOpenApi] changeVmrInfo:param callback:^(NSError *_Nullable error, id _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        } else {
            @strongify(self)
            [HWMConsoleManager shareInstance].console = @"edit succeeded";
            self.vmrInfoModel.guestPwd = self.guestPwd.length > 0 ? self.guestPwd : self.vmrInfoModel.guestPwd;
            self.vmrInfoModel.name = self.confSub.length > 0 ? self.confSub : self.vmrInfoModel.name;
            self.vmrInfoModel.chairmanPwd = self.chairmainPwd.length > 0 ? self.chairmainPwd : self.vmrInfoModel.chairmanPwd;
            [self.customNavigationController popViewControllerAnimated:YES];

            if (self.editVrmConfSuccessHandler) {
                self.editVrmConfSuccessHandler();
            }
        }
    }];
}

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    if (index == 6) {
        self.allowGuestStartConf = state;
    } else if (index == 8) {
        self.isOpenWaitingRoom = state;
    }
}


#pragma mark - Lazy

- (NSButton *)editBtn {
    if (!_editBtn) {
        _editBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(editBtnClick)];
        _editBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _editBtn.layer.cornerRadius = 4.0;
        _editBtn.layer.masksToBounds = YES;
    }
    return _editBtn;
}

@end
