//
//  HWMGetAttendeeListController.m
//  HWMUISDKNativeDemo
//
//  Created by guoyongliang/gwx917154 on 2021/7/9.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMGetAttendeeListController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMAttendeeManager.h"

@interface HWMGetAttendeeListController ()

@property (nonatomic, strong) NSButton *attendeeListBtn;

@property (nonatomic, strong) NSButton *audienceListBtn;

@end

@implementation HWMGetAttendeeListController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.attendeeListBtn];
    [self.attendeeListBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.centerY.equalTo(self.view).mas_offset(-10);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];

    [self.view addSubview:self.audienceListBtn];
    [self.audienceListBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(self.attendeeListBtn);
        make.top.mas_equalTo(self.attendeeListBtn.mas_bottom).mas_offset(20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Event
- (void)getAttendeeList {
    [HWMConsoleManager shareInstance].console = @"获取与会者列表";
    NSArray <HWMAttendeeInfo *> * attendees = [[HWMBizSdk getBizOpenApi] getAttendeeList];
    [HWMAttendeeManager logAttendees:attendees];
}

- (void)getAudienceList {
    [HWMConsoleManager shareInstance].console = @"获取观众列表";
    NSArray <HWMAttendeeInfo *> * attendees = [[HWMBizSdk getBizOpenApi] getAudienceList];
    [HWMAttendeeManager logAttendees:attendees];
}



#pragma mark - Lazy
- (NSButton *)attendeeListBtn {
    if (!_attendeeListBtn) {
        _attendeeListBtn = [NSButton buttonWithTitle:@"获取与会者列表" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(getAttendeeList)];
        _attendeeListBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _attendeeListBtn.layer.cornerRadius = 4.0;
        _attendeeListBtn.layer.masksToBounds = YES;
    }
    return _attendeeListBtn;
}

- (NSButton *)audienceListBtn {
    if (!_audienceListBtn) {
        _audienceListBtn = [NSButton buttonWithTitle:@"获取观众列表" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(getAudienceList)];
        _audienceListBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _audienceListBtn.layer.cornerRadius = 4.0;
        _audienceListBtn.layer.masksToBounds = YES;
    }
    return _audienceListBtn;
}

@end
