//
//  HWMLeaveConfController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/9.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMLeaveConfController.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMLeaveConfController ()

/// 离开会议
@property (nonatomic, strong) NSButton *leaveBtn;
/// 结束会议
@property (nonatomic, strong) NSButton *endBtn;

@end

@implementation HWMLeaveConfController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.leaveBtn];
    [self.view addSubview:self.endBtn];
    
    [self.leaveBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.view).offset(200);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
    
    [self.endBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.leaveBtn.mas_bottom).offset(40);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Event
- (void)leaveConf {
    if (![HWMSdk hasInit]) {

        return;
    }
    
    [[HWMBizSdk getBizOpenApi] leaveConf:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"%@", error.description];
        }else {
            [HWMConsoleManager shareInstance].console = @"已离开会议";
        }
    }];
}

- (void)endConf {
    if (![HWMSdk hasInit]) {

        return;
    }
    
    if (![[HWMBizSdk getBizOpenApi] selfIsChairMan]) {
        [HWMConsoleManager shareInstance].console = @"您不是主持人，无法结束会议";
        return;
    }
    
    [[HWMBizSdk getBizOpenApi] endConf:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        }else {
            [HWMConsoleManager shareInstance].console = @"会议已结束";
        }
    }];
}

#pragma mark - Lazy
- (NSButton *)leaveBtn {
    if (!_leaveBtn) {
        _leaveBtn = [NSButton buttonWithTitle:@"离开会议" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(leaveConf)];
        _leaveBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _leaveBtn.layer.cornerRadius = 4.0;
        _leaveBtn.layer.masksToBounds = YES;
    }
    return _leaveBtn;
}

- (NSButton *)endBtn {
    if (!_endBtn) {
        _endBtn = [NSButton buttonWithTitle:@"结束会议" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(endConf)];
        _endBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _endBtn.layer.cornerRadius = 4.0;
        _endBtn.layer.masksToBounds = YES;
    }
    return _endBtn;
}

@end
