//
//  HWMSDKCapabilityController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2021/12/15.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSDKCapabilityController.h"
#import <HWMUISDK/HWMUISDK.h>

static CGFloat const kCapabilityButtonWidth = 260.f;
static CGFloat const kCapabilityButtonHeight = 35.f;

@interface HWMSDKCapabilityController ()

@property (nonatomic, strong) NSButton *hdVideoBtn;
@property (nonatomic, strong) NSButton *shareAudioBtn;
@property (nonatomic, strong) NSButton *openCustomVBImageBtn;
@property (nonatomic, strong) NSButton *closeCustomVBImageBtn;
@property (nonatomic, strong) NSButton *hideNoCameraViewBtn;
@property (nonatomic, strong) NSButton *openConfirmRecordBtn;
@property (nonatomic, strong) NSButton *closeConfirmRecordBtn;
@property (nonatomic, strong) NSButton *openAlsoReceiveCallsBtn;
@property (nonatomic, strong) NSButton *closeAlsoReceiveCallsBtn;
@property (nonatomic, strong) NSButton *openIsWithoutMainFrameBtn;
@property (nonatomic, strong) NSButton *closeIsWithoutMainFrameBtn;
@property (nonatomic, strong) NSButton *openGuestInviteBtn;
@property (nonatomic, strong) NSButton *closeGuestInviteBtn;
@property (nonatomic, strong) NSButton *openHideInviteResultToastBtn;
@property (nonatomic, strong) NSButton *closeHideInviteResultToastBtn;
@property (nonatomic, strong) NSButton *openHideOfflineParticipantBtn;
@property (nonatomic, strong) NSButton *closeHideOfflineParticipantBtn;
@property (nonatomic, strong) NSButton *openBreakoutConfBtn;
@property (nonatomic, strong) NSButton *closeBreakoutConfBtn;
@property (nonatomic, strong) NSButton *openHideVbRiskTipBtn;
@property (nonatomic, strong) NSButton *closeHideVbRiskTipBtn;
@property (nonatomic, strong) NSButton *openConfEndShowTipBtn;
@property (nonatomic, strong) NSButton *closeConfEndShowTipBtn;
@property (nonatomic, strong) NSScrollView *scrollView;
@end

@interface HWMSDKCapabilityController ()

@end

@implementation HWMSDKCapabilityController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI
- (void)setupUI {
    self.scrollView = [[NSScrollView alloc] init];
    [self.view addSubview:self.scrollView];
    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.view);
    }];
    
    NSView *contentView = [[NSView alloc] init];
    contentView.wantsLayer = YES;
    self.scrollView.documentView = contentView;
    [contentView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(self.scrollView);
    }];
    self.hdVideoBtn = [self creatbButtonWithTitle:@"开启高清视频" tag:0];
    [contentView addSubview:self.hdVideoBtn];
    [self.hdVideoBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(contentView).offset(-kCapabilityButtonWidth/2.0 - 10);
        make.top.equalTo(contentView).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];

    self.shareAudioBtn = [self creatbButtonWithTitle:@"开启共享时包含电脑声音" tag:1];
    [contentView addSubview:self.shareAudioBtn];
    [self.shareAudioBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.hdVideoBtn);
        make.top.equalTo(self.hdVideoBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
        
    }];

    self.openCustomVBImageBtn = [self creatbButtonWithTitle:@"开启自定义虚拟背景" tag:2];
    [contentView addSubview:self.openCustomVBImageBtn];
    [self.openCustomVBImageBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.shareAudioBtn);
        make.top.equalTo(self.shareAudioBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];

    self.closeCustomVBImageBtn = [self creatbButtonWithTitle:@"关闭自定义虚拟背景" tag:3];
    [contentView addSubview:self.closeCustomVBImageBtn];
    [self.closeCustomVBImageBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openCustomVBImageBtn.mas_trailing).offset(20);
        make.top.equalTo(self.shareAudioBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];

    self.hideNoCameraViewBtn = [self creatbButtonWithTitle:@"关闭隐藏非视频与会者" tag:4];
    [contentView addSubview:self.hideNoCameraViewBtn];
    [self.hideNoCameraViewBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openCustomVBImageBtn);
        make.top.equalTo(self.openCustomVBImageBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];

    self.openConfirmRecordBtn = [self creatbButtonWithTitle:@"开启录制安全提示" tag:5];
    [contentView addSubview:self.openConfirmRecordBtn];
    [self.openConfirmRecordBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.hideNoCameraViewBtn);
        make.top.equalTo(self.hideNoCameraViewBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];

    self.closeConfirmRecordBtn = [self creatbButtonWithTitle:@"关闭录制安全提示" tag:6];
    [contentView addSubview:self.closeConfirmRecordBtn];
    [self.closeConfirmRecordBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openConfirmRecordBtn.mas_trailing).offset(20);
        make.top.equalTo(self.hideNoCameraViewBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];

    self.openAlsoReceiveCallsBtn = [self creatbButtonWithTitle:@"开启电脑端在线时移动端同时接收会议呼叫" tag:7];
    [contentView addSubview:self.openAlsoReceiveCallsBtn];
    [self.openAlsoReceiveCallsBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openConfirmRecordBtn);
        make.top.equalTo(self.openConfirmRecordBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];

    self.closeAlsoReceiveCallsBtn = [self creatbButtonWithTitle:@"关闭电脑端在线时移动端同时接收会议呼叫" tag:8];
    [contentView addSubview:self.closeAlsoReceiveCallsBtn];
    [self.closeAlsoReceiveCallsBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openAlsoReceiveCallsBtn.mas_trailing).offset(20);
        make.top.equalTo(self.openConfirmRecordBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    
    self.openIsWithoutMainFrameBtn = [self creatbButtonWithTitle:@"配置无会议主界面" tag:9];
    [contentView addSubview:self.openIsWithoutMainFrameBtn];
    [self.openIsWithoutMainFrameBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openAlsoReceiveCallsBtn);
        make.top.equalTo(self.openAlsoReceiveCallsBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];

    self.closeIsWithoutMainFrameBtn = [self creatbButtonWithTitle:@"配置有会议主界面" tag:10];
    [contentView addSubview:self.closeIsWithoutMainFrameBtn];
    [self.closeIsWithoutMainFrameBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openIsWithoutMainFrameBtn.mas_trailing).offset(20);
        make.top.equalTo(self.openAlsoReceiveCallsBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];

    self.openGuestInviteBtn = [self creatbButtonWithTitle:@"开启与会者邀请" tag:11];
    [contentView addSubview:self.openGuestInviteBtn];
    [self.openGuestInviteBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openIsWithoutMainFrameBtn);
        make.top.equalTo(self.openIsWithoutMainFrameBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];

    self.closeGuestInviteBtn = [self creatbButtonWithTitle:@"关闭与会者邀请" tag:12];
    [contentView addSubview:self.closeGuestInviteBtn];
    [self.closeGuestInviteBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openGuestInviteBtn.mas_trailing).offset(20);
        make.top.equalTo(self.openIsWithoutMainFrameBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    
    self.openHideInviteResultToastBtn = [self creatbButtonWithTitle:@"开启隐藏会中邀请提示" tag:13];
    [contentView addSubview:self.openHideInviteResultToastBtn];
    [self.openHideInviteResultToastBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openGuestInviteBtn.mas_leading);
        make.top.equalTo(self.openGuestInviteBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    
    self.closeHideInviteResultToastBtn = [self creatbButtonWithTitle:@"关闭隐藏会中邀请提示" tag:14];
    [contentView addSubview:self.closeHideInviteResultToastBtn];
    [self.closeHideInviteResultToastBtn mas_updateConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openHideInviteResultToastBtn.mas_trailing).offset(20);
        make.top.equalTo(self.openHideInviteResultToastBtn);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    
    self.openHideOfflineParticipantBtn = [self creatbButtonWithTitle:@"开启隐藏与会者列表未入会标签" tag:15];
    [contentView addSubview:self.openHideOfflineParticipantBtn];
    [self.openHideOfflineParticipantBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openHideInviteResultToastBtn.mas_leading);
        make.top.equalTo(self.openHideInviteResultToastBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    
    self.closeHideOfflineParticipantBtn = [self creatbButtonWithTitle:@"关闭隐藏与会者列表未入会标签" tag:16];
    [contentView addSubview:self.closeHideOfflineParticipantBtn];
    [self.closeHideOfflineParticipantBtn mas_updateConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openHideOfflineParticipantBtn.mas_trailing).offset(20);
        make.top.equalTo(self.openHideOfflineParticipantBtn);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    
    self.openBreakoutConfBtn = [self creatbButtonWithTitle:@"开启分组会议" tag:17];
    [contentView addSubview:self.openBreakoutConfBtn];
    [self.openBreakoutConfBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openHideOfflineParticipantBtn.mas_leading);
        make.top.equalTo(self.openHideOfflineParticipantBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    
    self.closeBreakoutConfBtn = [self creatbButtonWithTitle:@"关闭分组会议" tag:18];
    [contentView addSubview:self.closeBreakoutConfBtn];
    [self.closeBreakoutConfBtn mas_updateConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openBreakoutConfBtn.mas_trailing).offset(20);
        make.top.equalTo(self.openBreakoutConfBtn);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    
    self.openHideVbRiskTipBtn = [self creatbButtonWithTitle:@"开启隐藏虚拟背景隐私风险提示" tag:19];
    [contentView addSubview:self.openHideVbRiskTipBtn];
    [self.openHideVbRiskTipBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openBreakoutConfBtn.mas_leading);
        make.top.equalTo(self.openBreakoutConfBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    
    self.closeHideVbRiskTipBtn = [self creatbButtonWithTitle:@"关闭隐藏虚拟背景隐私风险提示" tag:20];
    [contentView addSubview:self.closeHideVbRiskTipBtn];
    [self.closeHideVbRiskTipBtn mas_updateConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openHideVbRiskTipBtn.mas_trailing).offset(20);
        make.top.equalTo(self.openHideVbRiskTipBtn);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    
    self.openConfEndShowTipBtn = [self creatbButtonWithTitle:@"开启展示confEnd提示" tag:21];
    [contentView addSubview:self.openConfEndShowTipBtn];
    [self.openConfEndShowTipBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openHideVbRiskTipBtn.mas_leading);
        make.top.equalTo(self.openHideVbRiskTipBtn.mas_bottom).offset(20);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
    }];
    self.closeConfEndShowTipBtn = [self creatbButtonWithTitle:@"关闭展示confEnd提示" tag:22];
    [contentView addSubview:self.closeConfEndShowTipBtn];
    [self.closeConfEndShowTipBtn mas_updateConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.openConfEndShowTipBtn.mas_trailing).offset(20);
        make.top.equalTo(self.openConfEndShowTipBtn);
        make.size.mas_equalTo(NSMakeSize(kCapabilityButtonWidth, kCapabilityButtonHeight));
        make.bottom.mas_equalTo(contentView).offset(-20);
    }];
}

- (NSButton *)creatbButtonWithTitle:(NSString *)title tag:(NSInteger)tag {
    NSButton *button = [NSButton buttonWithTitle:title font:nil fontColor:[NSColor whiteColor] target:self action:@selector(buttonEvent:)];
    button.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    button.layer.cornerRadius = 4.0;
    button.layer.masksToBounds = YES;
    button.tag = tag;
    return button;
}

#pragma mark - Event

- (void)buttonEvent:(NSButton *)button {
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }
    if (button.tag == 0) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilitySuportVideoHD];
        [HWMConsoleManager shareInstance].console = @"开启高清视频";
    } else if (button.tag == 1) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilitySuportShareAudio];
        [HWMConsoleManager shareInstance].console = @"开启共享时包含电脑声音";
    } else if (button.tag == 2) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilitySuportCustomVirtualBGImage];
        [HWMConsoleManager shareInstance].console = @"开启自定义虚拟背景";
    } else if (button.tag == 3) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilitySuportCustomVirtualBGImage];
        [HWMConsoleManager shareInstance].console = @"关闭自定义虚拟背景";
    } else if (button.tag == 4) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilitySuportHideNoCameraView];
        [HWMConsoleManager shareInstance].console = @"关闭隐藏非视频与会者";
    } else if (button.tag == 5) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilitySuportConfirmRecord];
        [HWMConsoleManager shareInstance].console = @"开启录制安全提示";
    } else if (button.tag == 6) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilitySuportConfirmRecord];
        [HWMConsoleManager shareInstance].console = @"关闭录制安全提示";
    } else if (button.tag == 7) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilitySuportAlsoReceiveCalls];
        [HWMConsoleManager shareInstance].console = @"开启电脑端在线时移动端同时接收会议呼叫";
    } else if (button.tag == 8) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilitySuportAlsoReceiveCalls];
        [HWMConsoleManager shareInstance].console = @"关闭电脑端在线时移动端同时接收会议呼叫";
    } else if (button.tag == 9) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilityWithoutMainFrame];
        [HWMConsoleManager shareInstance].console = @"配置无会议主界面";
    } else if (button.tag == 10) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilityWithoutMainFrame];
        [HWMConsoleManager shareInstance].console = @"配置有会议主界面";
    } else if (button.tag == 11) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilitySuportGuestInvite];
        [HWMConsoleManager shareInstance].console = @"开启与会者邀请";
    } else if (button.tag == 12) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilitySuportGuestInvite];
        [HWMConsoleManager shareInstance].console = @"关闭与会者邀请";
    } else if (button.tag == 13) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilityHideInviteResultToast];
        [HWMConsoleManager shareInstance].console = @"开启隐藏会中邀请提示";
    } else if (button.tag == 14) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilityHideInviteResultToast];
        [HWMConsoleManager shareInstance].console = @"关闭隐藏会中邀请提示";
    } else if (button.tag == 15) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilityHideOfflineParticipantList];
        [HWMConsoleManager shareInstance].console = @"开启隐藏与会者列表未入会标签";
    } else if (button.tag == 16) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilityHideOfflineParticipantList];
        [HWMConsoleManager shareInstance].console = @"关闭隐藏与会者列表未入会标签";
    } else if (button.tag == 17) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilitySuportBreakoutConf];
        [HWMConsoleManager shareInstance].console = @"开启分组会议";
    } else if (button.tag == 18) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilitySuportBreakoutConf];
        [HWMConsoleManager shareInstance].console = @"关闭分组会议";
    } else if (button.tag == 19) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilityHideVbRiskTip];
        [HWMConsoleManager shareInstance].console = @"开启隐藏虚拟背景隐私风险提示";
    } else if (button.tag == 20) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilityHideVbRiskTip];
        [HWMConsoleManager shareInstance].console = @"关闭隐藏虚拟背景隐私风险提示";
    } else if (button.tag == 21) {
        [[HWMBizSdk getBizOpenApi] enableSDKCapability:HWMSDKCapabilityConfEndShowTips];
        [HWMConsoleManager shareInstance].console = @"开启展示confEnd提示";
    } else if (button.tag == 22) {
        [[HWMBizSdk getBizOpenApi] disableSDKCapability:HWMSDKCapabilityConfEndShowTips];
        [HWMConsoleManager shareInstance].console = @"关闭展示confEnd提示";
    }
}

@end
