//
//  HWMSelectContactViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/4.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSelectContactViewController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMSDKTableView.h"
#import "HWMSelectContactViewCell.h"
#import "HWMContactInfoModel.h"
#import "HWMAddContactController.h"

@interface HWMSelectContactViewController ()<HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate, HWMSelectContactViewCellDelegate>
/// 数据
@property (nonatomic, strong) NSMutableArray <HWMContactInfoModel *> *dataArr;
@property (nonatomic, strong) NSMutableArray <HWMContactInfoModel *> *selectArr;
/// 列表
@property (nonatomic, strong) HWMSDKTableView *tableView;
/// 选中
@property (nonatomic, strong) NSMutableDictionary *selectDic;

@end

@implementation HWMSelectContactViewController

- (void)loadView {
    [super loadView];
    self.view.frame = NSMakeRect(0, 0, 500, 400);
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupData];
    [self setupUI];
}

- (void)viewDidAppear {
    [super viewDidAppear];
    [self createWindow];
}

#pragma mark - Data
- (void)setupData {
    self.dataArr = [NSMutableArray array];
    [self setAttendeesDataFromPlist:@"attendeesAccount"];
    [self setAttendeesDataFromPlist:@"attendeesAppId"];
}

- (void)setAttendeesDataFromPlist:(NSString *)plistName {
    NSString *accountPath = [[NSBundle bundleForClass:[self class]] pathForResource:plistName ofType:@"plist"];
    NSArray *accountArr = [NSArray arrayWithContentsOfFile:accountPath];
    NSArray *attendees = [NSArray yy_modelArrayWithClass:[HWMContactInfoModel class] json:accountArr];
    [self.dataArr addObjectsFromArray:attendees];
}

#pragma mark - UI
- (void)createWindow {
    NSWindow *window = self.view.window;
    window.title = @"选择联系人";
    window.backgroundColor = [NSColor colorWithRGB:0xF3F5F9];
    window.titlebarAppearsTransparent = YES;
    window.styleMask = NSWindowStyleMaskTitled | NSWindowStyleMaskClosable;
    [[window standardWindowButton:NSWindowZoomButton] setHidden:YES];
    [[window standardWindowButton:NSWindowMiniaturizeButton] setHidden:YES];
    NSButton *closeBtn = [window standardWindowButton:NSWindowCloseButton];
    closeBtn.target = self;
    closeBtn.action = @selector(closeBtnClose);
    [window center];
}

- (void)setupUI {
    
    self.tableView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"selectContact"];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];

    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.and.top.equalTo(self.view).offset(15);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.view).offset(-65);
    }];

    NSButton *confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
    confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    confirmBtn.layer.cornerRadius = 4.0;
    confirmBtn.layer.masksToBounds = YES;
    [self.view addSubview:confirmBtn];
    
    NSButton *addBtn = [NSButton buttonWithTitle:@"添加联系人" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(addBtnClick)];
    addBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    addBtn.layer.cornerRadius = 4.0;
    addBtn.layer.masksToBounds = YES;
    [self.view addSubview:addBtn];

    [confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.view).offset(55);
        make.bottom.equalTo(self.view).offset(-20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(150);
    }];
    
    [addBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self.view).offset(-55);
        make.bottom.equalTo(self.view).offset(-20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(150);
    }];
}

#pragma mark - Delegate

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.dataArr.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    HWMSelectContactViewCell *cell = [HWMSelectContactViewCell initSelectContactCell:tableView ower:self];
    HWMContactInfoModel *info = self.dataArr[row];
    cell.infoModel = info;
    cell.select = [[self.selectDic objectForKey:@(row)] boolValue];
    cell.index = row;
    cell.delegate = self;
    return cell;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 45;
}

- (void)selectConstactStateChanged:(NSInteger)index {
    BOOL select = [[self.selectDic objectForKey:@(index)] boolValue];
    HWMContactInfoModel *info = self.dataArr[index];
    if (select) {
        [self.selectArr removeObject:info];
        [self.selectDic setObject:@(NO) forKey:@(index)];
    } else {
        [self.selectArr addObject:info];
        [self.selectDic setObject:@(YES) forKey:@(index)];
    }
}

#pragma mark - Event
- (void)confirmBtnClick {
    if (self.selectAttendeeInfoHandler) {
        self.selectAttendeeInfoHandler(self.selectArr);
    }
    [self.view.window close];
    [NSApp stopModal];
}

- (void)addBtnClick {
    HWMAddContactController *add = [[HWMAddContactController alloc] init];
    @weakify(self)
    [add setAddContactHandler:^(HWMContactInfoModel * _Nullable contactInfo) {
        @strongify(self)
        [self.dataArr addObject:contactInfo];
        [self.tableView reloadData];
    }];
    [self presentViewControllerAsModalWindow:add];
}

- (void)closeBtnClose {
    if (self.selectAttendeeInfoHandler) {
        self.selectAttendeeInfoHandler(nil);
    }
    [self.view.window close];
    [NSApp stopModal];
}

#pragma mark - Lazy
- (NSMutableArray<HWMContactInfoModel *> *)selectArr {
    if (!_selectArr) {
        _selectArr = [NSMutableArray array];
    }
    return _selectArr;
}

- (NSMutableDictionary *)selectDic {
    if (!_selectDic) {
        _selectDic = [NSMutableDictionary dictionary];
    }
    return _selectDic;
}

@end
