//
//  HWMSubConfListViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/10/22.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSubConfListViewController.h"
#import "HWMSDKTableView.h"
#import "HWMSubCycleConfListCell.h"
#import "HWMEditeSubCycleConfController.h"
#import "NSViewController+HWMNavigation.h"
#import "HWMNavigationItem.h"

@interface HWMSubConfListViewController ()<HWMSDKTableViewDelegate, HWMSDKTableViewDataSourse>

/// 列表
@property (nonatomic, strong) HWMSDKTableView *listView;
/// 数据源
@property (nonatomic, strong) NSMutableArray <HWMSDKSubCycleConfParamModel *> *dataArr;

@end

@implementation HWMSubConfListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupData];
    [self setupUI];
}

- (void)viewDidAppear {
    [super viewDidAppear];
    [self.listView reloadData];
}

#pragma mark - Data
- (void)setupData {
    [self.dataArr addObjectsFromArray:self.detailModel.subConfParam];
}

#pragma mark - UI
- (void)setupUI {
    NSImage *image;
    if (@available(macOS 10.12, *)) {
        image = [NSImage imageNamed:NSImageNameGoBackTemplate];
    }
    self.backItem = [HWMNavigationItem itemWithTitle:@"返回" color:[NSColor colorWithRGB:0x333333] image:image target:self action:@selector(popViewController)];
    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"confList"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(45);
        make.leading.equalTo(self.view).offset(15);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.view).offset(-15);
    }];
}

- (void)popViewController {
    if (self.backBlock) {
        self.backBlock();
    }
    [self.customNavigationController popViewControllerAnimated:YES];
}
#pragma mark - Event
/// 取消周期子会议
- (void)cancelSubCycleConf:(HWMSDKSubCycleConfParamModel *)subParam {
    
    HWMSDKCancelSubCycleConfParamModel *param = [[HWMSDKCancelSubCycleConfParamModel alloc] init];
    param.subConfID = subParam.subConfID;
    param.confId = self.detailModel.confId;
    param.endOnlineConf = YES;
    
    @weakify(self)
    [[HWMBizSdk getBizOpenApi] cancelSubCycleConf:param callback:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        } else {
            [HWMConsoleManager shareInstance].console = @"cancel cycle conf successful";
            @strongify(self)
            [self.dataArr removeObject:subParam];
            [self.listView reloadData];
        }
    }];
}

- (void)editSubCycleConf:(HWMSDKSubCycleConfParamModel *)subParam {
    NSString *startTime = [NSString getLocalTimeZoneTimeWithTimeInterval:subParam.startTime format:@"yyyy-MM-dd HH:mm"];
    if ([self isOverTime: startTime]) {
        [HWMConsoleManager shareInstance].console = @"会议已开始，无法编辑";
        return;
    }
    
    HWMEditeSubCycleConfController *editVC = [[HWMEditeSubCycleConfController alloc] init];
    editVC.confID = self.detailModel.confId;
    editVC.subDatail = subParam;
    [self.customNavigationController pushViewController:editVC animated:YES];
}

- (BOOL)isOverTime:(NSString *)dateTime {
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateFormat:@"yyyy-MM-dd HH:mm"];
    NSDate *startDate = [formatter dateFromString:dateTime];
    NSDate *currentDate = [NSDate date];
    NSComparisonResult result = [startDate compare:currentDate];

    if (result ==  NSOrderedAscending) {
        return YES;
    } else if (result == NSOrderedDescending) {
        return NO;
    } else {
        // result == NSOrderedSame 也算是超时
        return YES;
    }
}

#pragma mark - Delegate

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.dataArr.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    HWMSubCycleConfListCell *cell = [HWMSubCycleConfListCell initSubCycleConfListCell:tableView ower:self];
    HWMSDKSubCycleConfParamModel *model = self.dataArr[row];
    [cell bindData:model];
    
    @weakify(self)
    [cell setCancelSubCycleConfHandler:^(HWMSDKSubCycleConfParamModel * _Nonnull subConf) {
        @strongify(self)
        [self cancelSubCycleConf:subConf];
    }];
    
    [cell setEditSubCycleConfHandler:^(HWMSDKSubCycleConfParamModel * _Nonnull subConf) {
        @strongify(self)
        [self editSubCycleConf:subConf];
    }];
    
    return cell;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 50.0;
}

#pragma mark - Lazy
- (NSMutableArray<HWMSDKSubCycleConfParamModel *> *)dataArr {
    if (!_dataArr) {
        _dataArr = [NSMutableArray array];
    }
    return _dataArr;
}
@end
