//
//  HWMUserStateController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2021/3/15.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMUserStateController.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMUserStateController ()

@property (nonatomic, strong) NSButton *stateBtn;

@end

@implementation HWMUserStateController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.stateBtn];
    [self.stateBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self.view);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Event
- (void)userState {
    HWMUserState userState = [[HWMSdk getOpenApi] getUserState];
    if (userState == HWMUserStateInConf) {
        [HWMConsoleManager shareInstance].console = @"用户状态 会议中";
    } else if (userState == HWMUserStateInCall) {
        [HWMConsoleManager shareInstance].console = @"用户状态 通话中";
    } else {
        [HWMConsoleManager shareInstance].console = @"用户状态 空闲";
    }
}

#pragma mark - Lazy
- (NSButton *)stateBtn {
    if (!_stateBtn) {
        _stateBtn = [NSButton buttonWithTitle:@"用户状态" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(userState)];
        _stateBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _stateBtn.layer.cornerRadius = 4.0;
        _stateBtn.layer.masksToBounds = YES;
    }
    return _stateBtn;
}

@end
