//
//  HWMVrmListViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/28.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMVrmListViewController.h"
#import "HWMConfListItem.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMEditVrmConfController.h"
#import "HWMNavigationController.h"
#import "NSViewController+HWMNavigation.h"
#import "HWMSDKTableView.h"

@interface HWMVrmListViewController ()<HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate>
/// tableView
@property (nonatomic, strong) HWMSDKTableView *listView;
/// 数据
@property (nonatomic, strong) NSMutableArray<HWMVmrInfoModel *> *dataArr;

@end

@implementation HWMVrmListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

- (void)viewDidAppear {
    [super viewDidAppear];
    [self loadData];
}

#pragma mark - Data
- (void)loadData {
    if (![HWMSdk hasInit]) {
        return;
    }
    @weakify(self)
    [[HWMBizSdk getBizOpenApi] getVmrInfoList:^(NSError * _Nullable error, HWMVmrInfoListModel * _Nullable result) {
        @strongify(self)
        [self.dataArr removeAllObjects];
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        } else {
            [self.dataArr addObjectsFromArray:result.vmrs];
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"vmr conf count: %lu", self.dataArr.count];
        }
        [self.listView reloadData];
    }];
}

#pragma mark - UI
- (void)setupUI {
    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"vrmList"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.and.top.equalTo(self.view).offset(15);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.view).offset(-15);
    }];
}

#pragma mark - Delegate
- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.dataArr.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    HWMConfListItem *item = [HWMConfListItem initConfListItem:tableView ower:self];
    item.vmrInfo = self.dataArr[row];
    @weakify(self)
    [item setVmrListItemClickHandler:^(HWMVmrInfoModel *_Nonnull vmrInfo) {
        @strongify(self)
        [self editVmrConf: vmrInfo];
    }];
    return item;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 50.0;
}

- (BOOL)tableView:(NSTableView *)tableView shouldSelectRow:(NSInteger)row {
    HWMVmrInfoModel *infoModel = self.dataArr[row];
    HWMEditVrmConfController *editVC = [[HWMEditVrmConfController alloc] init];
    editVC.vmrInfoModel = infoModel;
    @weakify(self)
    [editVC setEditVrmConfSuccessHandler:^{
        @strongify(self)
        [self.listView reloadData];
    }];
    [self.customNavigationController pushViewController:editVC animated:YES];
    return YES;
}

#pragma mark - Event
- (void)editVmrConf:(HWMVmrInfoModel *)infoModel {
    HWMEditVrmConfController *editVC = [[HWMEditVrmConfController alloc] init];
    editVC.vmrInfoModel = infoModel;
    @weakify(self)
    [editVC setEditVrmConfSuccessHandler:^{
        @strongify(self)
        [self.listView reloadData];
    }];
    [self.customNavigationController pushViewController:editVC animated:YES];
}

#pragma mark - Lazy

- (NSMutableArray<HWMVmrInfoModel *> *)dataArr {
    if (!_dataArr) {
        _dataArr = [NSMutableArray array];
    }
    return _dataArr;
}

@end
